package de.xam.triplerules.impl;

import de.xam.triplerules.IRuleConditionBinding;
import de.xam.triplerules.ITriplePattern;
import de.xam.triplerules.ITripleRule;
import de.xam.triplerules.IVariable;

/**
 * @author xamde
 *
 * @param <K>
 * @param <L>
 * @param <M>
 */
public class TriplePattern<K, L, M> implements ITriplePattern<K, L, M> {

	public TriplePattern(final IVariable<K> s, final IVariable<L> p, final IVariable<M> o) {
		super();
		this.s = s;
		this.p = p;
		this.o = o;
	}

	public TriplePattern(final String sName, final K s, final String pName, final L p, final String oName, final M o) {
		this(toVariable(sName, s), toVariable(pName, p), toVariable(oName, o));
	}

	private static <E> IVariable<E> toVariable(final String name, final E expect) {
		return expect == null ? new WildcardVariable<E>(name) : new EqualsVariable<E>(name, expect);
	}

	private IVariable<K> s;
	private IVariable<L> p;
	private IVariable<M> o;

	@Override
	public IVariable<K> s() {
		return this.s;
	}

	@Override
	public IVariable<L> p() {
		return this.p;
	}

	@Override
	public IVariable<M> o() {
		return this.o;
	}

	@Override
	public String toString() {
		return toString(null);
	}

	@Override
	public int hashCode() {
		return this.s.hashCode() + this.p.hashCode() + this.o.hashCode();
	}

	@Override
	public boolean equals(final Object other) {
		return other instanceof TriplePattern

		&& ((TriplePattern<?, ?, ?>) other).s.equals(this.s)
				&& ((TriplePattern<?, ?, ?>) other).p.equals(this.p)
				&& ((TriplePattern<?, ?, ?>) other).o.equals(this.o)

		;
	}

	@Override
	public void compile(final ITripleRule<K, L, M> rule) {
		this.s.compile(rule);
		this.p.compile(rule);
		this.o.compile(rule);
	}

	@Override
	public String toString(final IRuleConditionBinding<K, L, M> binding) {
		return "(" + this.s.toString(binding) + ", " + this.p.toString(binding) + ", "
				+ this.o.toString(binding) + ")";
	}

	@Override
	public boolean isBound(final IRuleConditionBinding<K, L, M> binding) {
		if (this.s.isStar() && !binding.isBound(this.s)) {
			return false;
		}
		if (this.p.isStar() && !binding.isBound(this.p)) {
			return false;
		}
		if (this.o.isStar() && !binding.isBound(this.o)) {
			return false;
		}

		return true;
	}

	public static <K, L, M> ITriplePattern<K, L, M> matchAlways() {
		return new ITriplePattern<K, L, M>() {

			private final WildcardVariable<K> anyS = new WildcardVariable<K>("any-s");
			private final WildcardVariable<L> anyP = new WildcardVariable<L>("any-p");
			private final WildcardVariable<M> anyO = new WildcardVariable<M>("any-o");

			@Override
			public IVariable<K> s() {
				return this.anyS;
			}

			@Override
			public IVariable<L> p() {
				return this.anyP;
			}

			@Override
			public IVariable<M> o() {
				return this.anyO;
			}

			@Override
			public void compile(final ITripleRule<K, L, M> rule) {
			}

			@Override
			public String toString(final IRuleConditionBinding<K, L, M> binding) {
				return "(ALL: *,*,*)";
			}

			@Override
			public boolean isBound(final IRuleConditionBinding<K, L, M> binding) {
				return false;
			}
		};
	}

}
