package de.xam.triplerules.impl;

import de.xam.triplerules.ITriplePattern;
import de.xam.triplerules.IVariable;

public class DefaultCostEstimator<K, L, M> implements ICostEstimator<K, L, M> {

	@Override
	public double estimatedCosts(final ITriplePattern<K, L, M> pattern) {
		return estimatedCosts(pattern, null);
	}

	/**
	 * @param pattern
	 * @return 0 if pattern has no costs (= completely defined).
	 */
	@Override
	public double estimatedCosts(final ITriplePattern<K, L, M> pattern, final ConditionBinding<K, L, M> binding) {
		// simple rating: just count number of open variables
		double open = 0;
		open += estimateCosts(pattern.s(), binding);
		open += estimateCosts(pattern.p(), binding);
		open += estimateCosts(pattern.o(), binding);
		return open;
	}

	private <E> double estimateCosts(final IVariable<E> var, final ConditionBinding<K, L, M> binding) {
		if (var.isStar() && (binding == null || !binding.isBound(var))) {
			return 1;
		} else {
			return 0;
		}
	}

}
