package de.xam.triplerules;

import java.io.Serializable;
import java.util.Collection;
import java.util.Set;

import org.xydra.annotations.Feature;
import org.xydra.index.query.ITriple;

/**
 * State: A set of triples + dirty flag
 *
 * For communication between high-level rule engine and low-level ITTI.
 *
 * @author xamde
 *
 * @param <K>
 * @param <L>
 * @param <M>
 */
// TODO let implement IComputedState
public class TripleSetWithDirtyFlag<K extends Serializable, L extends Serializable, M extends Serializable>
		implements Serializable {

	public TripleSetWithDirtyFlag(final Set<ITriple<K, L, M>> set, final boolean isDirty) {
		this.set = set;
		this.isDirty = isDirty;
	}

	public synchronized boolean add(final ITriple<K, L, M> triple) {
		return this.set.add(triple);
	}

	private final Set<ITriple<K, L, M>> set;

	@Feature("dirtyFlag")
	private boolean isDirty;

	@Feature("dirtyFlag")
	public void markAsDirty() {
		this.isDirty = true;
	}

	public synchronized boolean isEmpty() {
		return this.set.isEmpty();
	}

	public synchronized int size() {
		return this.set.size();
	}

	public synchronized void clear() {
		this.set.clear();
	}

	/**
	 * Export all triples to {@link Collection}
	 *
	 * @param colllection
	 */
	public synchronized void exportAllTo(final Collection<ITriple<K, L, M>> colllection) {
		colllection.addAll(this.set);
	}

	@Feature("dirtyFlag")
	public synchronized boolean isAllInferred() {
		return !this.isDirty;
	}

	@Feature("dirtyFlag")
	public synchronized void markAsComputed() {
		this.isDirty = false;
	}

}
