package de.xam.textsearch.util;

/**
 * Normalizes strings for indexing and search, e.g. toLowercase, could also do
 * stemming, trim, or strange character removal.
 *
 * You can use {@link #LOWERCASE}.
 */
public interface INormaliser {

	/** Standard implementation: toLowercase */
	public static final INormaliser LOWERCASE = new INormaliser() {

		@Override
		public String normalise(final String raw) {
			return raw.toLowerCase();
		}
	};

	/**
	 * Normalises tokens. Same normalisation must happen for indexed terms and
	 * for lookup query parts.
	 *
	 * @param raw
	 * @return a normalised String or @CanBeNull to report a string should not
	 *         be indexed at all
	 */
	String normalise(String raw);
}
