package de.xam.textsearch.query;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

import org.xydra.index.iterator.ClosableIterator;
import org.xydra.index.iterator.ClosableIteratorAdapter;
import org.xydra.index.iterator.Iterators;

import com.google.gwt.thirdparty.guava.common.base.Joiner;

public class OrQuery<V> extends AbstractCombinedQuery<V> implements IQuery<V> {

	public static <V> OrQuery<V> create(final IQuery<V> subQuery) {
		final OrQuery<V> orQuery = new OrQuery<V>();
		return orQuery.or(subQuery);
	}

	public static <V> OrQuery<V> create() {
		final OrQuery<V> orQuery = new OrQuery<V>();
		return orQuery;
	}

	public OrQuery<V> or(final IQuery<V> subQuery) {
		add(subQuery);
		return this;
	}

	@Override
	public Set<V> executeToSet() {
		switch (this.queries.size()) {
		case 0:
			return Collections.emptySet();
		case 1:
			return this.queries.get(0).executeToSet();
		default:
			final Set<V> firstSet = this.queries.get(0).executeToSet();
			final Set<V> result = new HashSet<V>(firstSet.size());
			result.addAll(firstSet);
			for (int i = 1; i < this.queries.size(); i++) {
				final Set<V> ithSet = this.queries.get(0).executeToSet();
				result.addAll(ithSet);
			}
			return result;
		}
	}

	@Override
	public String toString() {
		final StringBuilder b = new StringBuilder();
		b.append("(");
		Joiner.on(" OR ").appendTo(b, super.queries);
		b.append(")");
		return b.toString();
	}

	@SuppressWarnings({ "rawtypes", "unchecked" })
	@Override
	public ClosableIterator<V> execute() {
		switch (this.queries.size()) {
		case 0:
			return Iterators.none();
		case 1:
			return this.queries.get(0).execute();
		default:
			/* compute a set in which each element from any subquery result occurs only once */
			// IMPROVE find more efficient way
			final Set<V> firstSet = this.queries.get(0).executeToSet();
			final Set<V> result = new HashSet<V>(firstSet.size());
			result.addAll(firstSet);
			for (int i = 1; i < this.queries.size(); i++) {
				final Set<V> ithSet = this.queries.get(0).executeToSet();
				result.addAll(ithSet);
			}

			return new ClosableIteratorAdapter(result.iterator());
		}
	}

}
