package de.xam.textsearch.compare;

import java.util.Comparator;

import org.xydra.index.iterator.IFilter;

import de.xam.textsearch.Match;

/**
 * Values matching the filter are strictly sorted before those values that dont
 * match.
 *
 * @param <V>
 */
public class OptionalFilterComparator<V> implements Comparator<Match<V>> {

	private final IFilter<V> filter;

	/**
	 * @param filter @CanBeNull
	 */
	public OptionalFilterComparator(final IFilter<V> filter) {
		this.filter = filter;
	}

	@Override
	public int compare(final Match<V> a, final Match<V> b) {
		return compare_static(a, b, this.filter);
	}

	public static <T> int compare_static(final Match<T> a, final Match<T> b, final IFilter<T> filter) {

		if (filter == null) {
			return 0;
		}

		final boolean preferA = filter.matches(a.getValue());
		final boolean preferB = filter.matches(b.getValue());

		if (preferA) {
			if (preferB) {
				return 0;
			} else {
				return -1;
			}
		} else {
			if (preferB) {
				return 1;
			} else {
				return 0;
			}
		}
	}

}
