package de.xam.textsearch.compare;

import java.util.Comparator;

import de.xam.textsearch.Match;
import de.xam.textsearch.spi.IContentResolver;

/**
 * Comparing matches is done by comparing the projected string content of the
 * value objects
 *
 * @param <V>
 */
public class LongestFirstMatchComperator<V> implements Comparator<Match<V>> {

	public LongestFirstMatchComperator(final IContentResolver<V> contentResolver) {
		this.contentResolver = contentResolver;
	}

	private final IContentResolver<V> contentResolver;

	@Override
	public int compare(final Match<V> a, final Match<V> b) {
		return compare_static(a, b, this.contentResolver);
	}

	public static <T> int compare_static(final Match<T> a, final Match<T> b, final IContentResolver<T> contentResolver) {
		final String aContent = contentResolver.getContentAsStringForTextIndexing(a.getValue());
		final String bContent = contentResolver.getContentAsStringForTextIndexing(b.getValue());

		return bContent.length() - aContent.length();
	}

}
