package de.xam.p13n.shared.time;

import java.util.Date;

import org.xydra.annotations.RunsInGWT;
import org.xydra.annotations.Template;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

/**
 * Provides fake-able time
 *
 * @author xamde
 */
@RunsInGWT(true)
public class TimeProvider {

	protected static long fakeTime_ = 0;

	private static final Logger log = LoggerFactory.getLogger(TimeProvider.class);

	@Template("current time as a nice string")
	public static String getCurrentTime() {
		return "" + new Date(getCurrentTimeInMillis());
	}

	public static MiniDateTime getCurrentTimeAsDateTime() {
		final long time = getCurrentTimeInMillis();
		final MiniDateTime dt = new MiniDateTime(time);
		return dt;
	}

	public static long getCurrentTimeInMillis() {
		if (isFakeTime()) {
			return fakeTime_;
		} else {
			return System.currentTimeMillis();
		}
	}

	@Template("true if the time is a fake time")
	public static boolean isFakeTime() {
		return fakeTime_ > 0;
	}

	/**
	 * @param fakeTime
	 *            set to 0 to use real time
	 */
	public static void setFakeTime(final long fakeTime) {
		fakeTime_ = fakeTime;
	}

	public static void setFakeTimeFromString(final String fakeTimeString) {
		final long fakeTime = Long.parseLong(fakeTimeString);
		setFakeTime(fakeTime);
		log.warn("Set fake time to " + fakeTime);
	}

}
