package de.xam.p13n.shared.time;

import java.util.Date;

import org.xydra.annotations.RunsInGWT;

/**
 * GWT-able version of JodaTime's DateTime
 *
 * TODO 2012-03 use timezone
 *
 * @author xamde
 *
 */
@RunsInGWT(true)
public class MiniDateTime implements Comparable<MiniDateTime> {

	private transient Date date;

	private final long millis;

	@SuppressWarnings("deprecation")
	public MiniDateTime(final int year, final int monthOfYear, final int dayOfMonth, final int hour, final int minute,
			final int second, final int millis) {
		this.millis = Date.UTC(year - 1900, monthOfYear - 1, dayOfMonth, hour, minute, second);
	}

	public MiniDateTime(final long millis) {
		this.millis = millis;
	}

	@Override
	public boolean equals(final Object other) {
		return other instanceof MiniDateTime && ((MiniDateTime) other).millis == this.millis;
	}

	@SuppressWarnings("deprecation")
	public int getDayOfMonth() {
		lazyInitDate();
		return this.date.getDate();
	}

	public long getMillis() {
		return this.millis;
	}

	@SuppressWarnings("deprecation")
	public int getMonthOfYear() {
		lazyInitDate();
		return this.date.getMonth() + 1;
	}

	@SuppressWarnings("deprecation")
	public int getYear() {
		lazyInitDate();
		return this.date.getYear() + 1900;
	}

	@Override
	public int hashCode() {
		return new Long(this.millis).hashCode();
	}

	@SuppressWarnings("deprecation")
	private void lazyInitDate() {
		if (this.date == null) {
			this.date = new Date(this.millis);
			// shift date against its offset
			final int offsetMinutes = this.date.getTimezoneOffset();
			final long offsetMillis = offsetMinutes * 60 * 1000;
			this.date.setTime(this.millis + offsetMillis);
		}
	}

	public MiniLocalDate toLocalDate() {
		return new MiniLocalDate(getMillis());
	}

	@SuppressWarnings("deprecation")
	@Override
	public String toString() {
		lazyInitDate();
		return toLocalDate().toString() + "-" + this.date.getHours() + "-"
				+ this.date.getMinutes() + "-" + this.date.getSeconds();
	}

	@Override
	public int compareTo(final MiniDateTime other) {
		if (other == null) {
			return -1;
		}

		if (this.millis < other.millis) {
			return -1;
		} else if (other.millis == this.millis) {
			return 0;
		} else {
			return 1;
		}
	}

	public static MiniDateTime now() {
		return new MiniDateTime(TimeProvider.getCurrentTimeInMillis());
	}

	/**
	 * @param a
	 * @param b
	 * @return -1 if one of the params is null, 0 or -1 it self. Otherwise
	 *         return the number of minutes between the two time points.
	 */
	public static int minutesBetween(final MiniDateTime a, final MiniDateTime b) {
		if (a == null || b == null || a.millis == -1 || b.millis == -1 || a.millis == 0
				|| b.millis == 0) {
			return -1;
		}
		final long millis = b.millis - a.millis;
		final int minutes = (int) (millis / (60 * 1000));
		return minutes;
	}

}
