package de.xam.p13n.shared;

import org.joda.time.DateTimeZone;
import org.xydra.conf.IConfig;
import org.xydra.conf.IConfigProvider;
import org.xydra.conf.annotations.ConfDoc;
import org.xydra.conf.annotations.ConfType;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;

import de.xam.p13n.shared.time.TimeProvider;

public class ConfParamsP13n implements IConfigProvider {

	@ConfType(boolean.class)
	@ConfDoc("If true, we run in production and skip a number of slow internal checks, but do run more security things.")
	public static final String CACHE_BUNDLES = "p13n-cacheBundles";

	/** Cache<String,Object> */
	@ConfType(Cache.class)
	@ConfDoc("runtime p13n cache object")
	public static final String INSTANCE_CACHE = "p13n-instanceCache";

	@ConfType(Personalisation.class)
	@ConfDoc("Personalisation")
	public static final String P13N = "p13n";

	/**
	 * @return the default {@link Personalisation} for GoalTaxi :-) which is
	 *         German language located in Germany
	 */
	private static final Personalisation createDefaultP13n() {
		final DateTimeZone berlin = DateTimeZone.forID("Europe/Berlin");
		final long offsetMillis = berlin.getOffset(TimeProvider.getCurrentTimeInMillis());
		final int offsetHours = (int) (offsetMillis / (60 * 60 * 1000));
		return new Personalisation(MiniLocale.De_DE, offsetHours);
	}

	@Override
	public void configureDefaults(final IConfig conf) {
		conf.setDefault(P13N, createDefaultP13n(), true);
		conf.setDefault(CACHE_BUNDLES, true, true);
		final Cache<String, Object> instanceCache = CacheBuilder.newBuilder().build();
		conf.setInstance(INSTANCE_CACHE, instanceCache);
	}

}
