// for items
var bloodhound = new Bloodhound({
	datumTokenizer : Bloodhound.tokenizers.obj.whitespace('value'),
	queryTokenizer : Bloodhound.tokenizers.whitespace,
	limit : 40,
	prefetch : '/query/items/autocomplete/prefetch',
	remote : {
		"url" : '/query/items/autocomplete?q=%QUERY&output=json',
		"rateLimitWait" : 1,

	},
	dupDetector : function(remoteMatch, localMatch) {
		return remoteMatch.xid == localMatch.xid;
	}
});
bloodhound.initialize();

// for properties
var bloodhoundProp = new Bloodhound(
		{
			datumTokenizer : Bloodhound.tokenizers.obj.whitespace('value'),
			queryTokenizer : Bloodhound.tokenizers.whitespace,
			limit : 40,
			remote : {
				"url" : '/query/items/autocomplete?q=%QUERY&output=json&filter=Properties',
				"rateLimitWait" : 1,

			},
			dupDetector : function(remoteMatch, localMatch) {
				return remoteMatch.xid == localMatch.xid;
			}
		});
bloodhoundProp.initialize();

// for relations
var bloodhoundRel = new Bloodhound(
		{
			datumTokenizer : Bloodhound.tokenizers.obj.whitespace('value'),
			queryTokenizer : Bloodhound.tokenizers.whitespace,
			limit : 40,
			remote : {
				"url" : '/query/items/autocomplete?q=%QUERY&output=json&filter=Relations',
				"rateLimitWait" : 1,

			},
			dupDetector : function(remoteMatch, localMatch) {
				return remoteMatch.xid == localMatch.xid;
			}
		});
bloodhoundRel.initialize();

$(document).ready(function() {

	// ------------------------------------------------
	// auto-complete in top search bar

	$('#search .typeahead').typeahead({
		highlight : true
	}, {
		name : 'remote-localhost',
		displayKey : 'value',
		source : bloodhound.ttAdapter()
	})

	.bind('typeahead:selected', function(event, sugg, datasetname) {
		// use .xid for the id
		document.location = "/item/" + sugg.xid;
	})

	;

	// ------------------------------------------------
	// auto-complete GENERIC item names

	$('.autocomplete-item-name-submit').typeahead({
		highlight : true,
		minLength : 0
	}, {
		name : 'remote-localhost',
		displayKey : 'value',
		source : bloodhound.ttAdapter()
	})

	.bind('typeahead:selected', function(event, sugg, datasetname) {
		// use .xid for the id
		$(this).parent().parent().find('.autocomplete-item-id').val(sugg.xid);
		// ugly hack to have code reusable
		$(this).parent().parent().submit();
		$(this).parent().parent().parent().parent().parent().parent().submit();
	});

	$('.autocomplete-item-name').typeahead({
		highlight : true,
		minLength : 0
	}, {
		name : 'remote-localhost',
		displayKey : 'value',
		source : bloodhound.ttAdapter()
	})

	.bind('typeahead:selected', function(event, sugg, datasetname) {
		// use .xid for the id
		$(this).parent().parent().find('.autocomplete-item-id').val(sugg.xid);
	});

	// ------------------------------------------------
	// auto-complete GENERIC PROPERTY names

	$('.autocomplete-prop-name').typeahead({
		highlight : true,
		minLength : 0
	}, {
		name : 'remote-localhost-prop',
		displayKey : 'value',
		source : bloodhoundProp.ttAdapter()
	})

	.bind('typeahead:selected', function(event, sugg, datasetname) {
		// use .xid for the id
		$(this).parent().parent().find('.autocomplete-prop-id').val(sugg.xid);
		$(this).parent().parent().parent().find("#property-adder-o-value").focus();
	});

	// ------------------------------------------------
	// auto-complete GENERIC RELATION from name to id

	$('.autocomplete-rel-name').typeahead({
		highlight : true,
		minLength : 0
	}, {
		name : 'remote-localhost-rel',
		displayKey : 'value',
		source : bloodhoundRel.ttAdapter()
	})

	.bind('typeahead:selected', function(event, sugg, datasetname) {
		// use .xid for the id
		$(this).parent().parent().find(".autocomplete-rel-id").val(sugg.xid);
		$(this).parent().parent().parent().find("#relation-adder-o-name").focus();
	});

});