package com.calpano.common.shared.xydrautils.impl;

import org.xydra.annotations.RunsInGWT;
import org.xydra.base.XId;
import org.xydra.base.rmof.XWritableModel;

import com.calpano.common.shared.xydrautils.IBasedOnXWritableModel;

/**
 * Straight implementation of {@link IBasedOnXWritableModel} interface.
 *
 * Holds an {@link XWritableModel} reference.
 *
 * @author xamde
 */
@RunsInGWT(true)
public class BasedOnXWritableModel extends BasedOnXReadableModel implements IBasedOnXWritableModel {

	private static final long serialVersionUID = 3409391440761110179L;

	/** provided to sub-classes */
	protected XId actorId;

	/** provided to sub-classes */
	protected XWritableModel writableModel;

	/**
	 * GWT-only constructor for serialisation.
	 */
	protected BasedOnXWritableModel() {
		super();
	}

	/**
	 * @param proto
	 */
	public BasedOnXWritableModel(final IBasedOnXWritableModel proto) {
		this(proto.getXWritableModel(), proto.getActorId());
	}

	/**
	 * If model is null, must be given later via
	 * {@link #setWritableModel(XWritableModel)} before use.
	 *
	 * @param xm
	 *            persists part of the state of the represented object, e.g. the
	 *            email-address-index @CanBeNull
	 * @param actorId
	 *            ..
	 */
	public BasedOnXWritableModel(final XWritableModel xm, final XId actorId) {
		this.writableModel = xm;
		this.actorId = actorId;
		this.readableModel = this.writableModel;
	}

	@Override
	public XWritableModel getXWritableModel() {
		return this.writableModel;
	}

	@Override
	public XId getActorId() {
		return this.actorId;
	}

	public void setWritableModel(final XWritableModel model) {
		this.writableModel = model;
		this.readableModel = model;
	}

	public void setActorId(final XId actorId) {
		this.actorId = actorId;
	}

}
