package com.calpano.common.shared.xydrautils.impl;

import org.xydra.annotations.RunsInGWT;
import org.xydra.base.XAddress;
import org.xydra.base.XId;
import org.xydra.base.rmof.XReadableObject;
import org.xydra.base.rmof.XWritableObject;

import com.calpano.common.shared.xydrautils.IBasedOnXReadableObject;
import com.calpano.common.shared.xydrautils.IBasedOnXWritableObject;

/**
 * Straight implementation of {@link IBasedOnXWritableObject} interface.
 *
 * Holds an {@link XWritableObject} reference.
 *
 * @author xamde
 */
@RunsInGWT(true)
public class BasedOnXReadableObject implements IBasedOnXReadableObject {

	private static final long serialVersionUID = 9214135195087574094L;

	protected XReadableObject readableObject;

	/**
	 * GWT-only constructor for serialisation.
	 */
	protected BasedOnXReadableObject() {
		super();
	}

	public BasedOnXReadableObject(final IBasedOnXReadableObject proto) {
		this(proto.getXObject());
	}

	public BasedOnXReadableObject(final XReadableObject xo) {
		this.readableObject = xo;
	}

	@Override
	public boolean equals(final Object other) {
		return other instanceof IBasedOnXReadableObject
				&& this.readableObject.getAddress().equals(
						((IBasedOnXReadableObject) other).getXObject().getAddress());
	}

	@Override
	public XAddress getAddress() {
		return this.readableObject.getAddress();
	}

	@Override
	public XId getId() {
		return this.readableObject.getId();
	}

	@Override
	public XReadableObject getXObject() {
		return this.readableObject;
	}

	@Override
	public int hashCode() {
		return this.readableObject.getAddress().hashCode();
	}

	@Override
	public String toString() {
		assert getXObject() != null;
		return getXObject().toString();
	}

}
