package com.calpano.common.shared.xydrautils.impl;

import org.xydra.annotations.RunsInGWT;
import org.xydra.base.XAddress;
import org.xydra.base.XId;
import org.xydra.base.rmof.XReadableModel;

import com.calpano.common.shared.xydrautils.IBasedOnXReadableModel;

/**
 * Straight implementation of {@link IBasedOnXReadableModel} interface.
 *
 * Holds an {@link XReadableModel} reference.
 *
 * @author xamde
 */
@RunsInGWT(true)
public class BasedOnXReadableModel implements IBasedOnXReadableModel {

	private static final long serialVersionUID = 3409391440761110179L;

	protected XReadableModel readableModel;

	/**
	 * GWT-only constructor for serialisation.
	 */
	protected BasedOnXReadableModel() {
		super();
	}

	public BasedOnXReadableModel(final IBasedOnXReadableModel proto) {
		this.readableModel = proto.getXWritableModel();
	}

	/**
	 * @param xm
	 *            persists part of the state of the represented object, e.g. the
	 *            email-address-index
	 * @param actorId
	 *            ..
	 */
	public BasedOnXReadableModel(final XReadableModel xm, final XId actorId) {
		this.readableModel = xm;
	}

	@Override
	public boolean equals(final Object other) {
		return other instanceof IBasedOnXReadableModel
				&& this.readableModel.equals(((IBasedOnXReadableModel) other).getXWritableModel());
	}

	@Override
	public XAddress getAddress() {
		return this.readableModel.getAddress();
	}

	@Override
	public XId getId() {
		return this.readableModel.getId();
	}

	@Override
	public XReadableModel getXWritableModel() {
		return this.readableModel;
	}

	@Override
	public int hashCode() {
		return this.readableModel.hashCode();
	}

}
