package com.calpano.common.shared.xydrautils.field;

import java.util.Set;
import java.util.TreeSet;

import org.xydra.base.BaseRuntime;
import org.xydra.base.XId;
import org.xydra.base.value.XIdSetValue;

public class XIDSetFieldProperty extends ExtensibleFieldProperty<Set<XId>, XIdSetValue> {

	public XIDSetFieldProperty(final String fieldIdString) {
		super(fieldIdString, new Converter<Set<XId>, XIdSetValue>() {

			@Override
			public Set<XId> toJavaType(final XIdSetValue xydraType) {
				if (xydraType == null) {
					return new TreeSet<XId>();
				} else {
					return xydraType.toSet();
				}
			}

			@Override
			public XIdSetValue toXydraValue(final Set<XId> anyType) {
				return BaseRuntime.getValueFactory().createIdSetValue(anyType);
			}
		});
	}

}
