package com.calpano.common.shared.xydrautils.field;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.xydra.base.BaseRuntime;
import org.xydra.base.XId;
import org.xydra.base.value.XIdListValue;

public class XIDListFieldProperty extends ExtensibleFieldProperty<List<XId>, XIdListValue> {

	public XIDListFieldProperty(final String fieldIdString) {
		super(fieldIdString, new Converter<List<XId>, XIdListValue>() {

			@Override
			public List<XId> toJavaType(final XIdListValue xydraType) {
				if (xydraType == null) {
					return new ArrayList<XId>();
				} else {
					return Arrays.asList(xydraType.toArray());
				}
			}

			@Override
			public XIdListValue toXydraValue(final List<XId> anyType) {
				return BaseRuntime.getValueFactory().createIdListValue(anyType);
			}
		});
	}

}
