package com.calpano.common.shared.xydrautils.field;

import org.xydra.base.value.XStringValue;
import org.xydra.base.value.XV;

import de.xam.p13n.shared.Personalisation;

public class P13nFieldProperty extends ExtensibleFieldProperty<Personalisation, XStringValue> {

	public P13nFieldProperty(final String fieldIdString) {
		super(fieldIdString,
				new ExtensibleFieldProperty.Converter<Personalisation, XStringValue>() {

					@Override
					public Personalisation toJavaType(final XStringValue xydraType) {
						if (xydraType == null) {
							return null;
						}
						return Personalisation.fromString(xydraType.contents());
					}

					@Override
					public XStringValue toXydraValue(final Personalisation anyType) {
						if (anyType == null) {
							return null;
						}
						return XV.toValue(anyType.toCompactString());
					}

				});
	}

}
