package com.calpano.common.shared.xydrautils.field;

import org.xydra.base.BaseRuntime;
import org.xydra.base.value.XStringValue;

public class EnumFieldProperty<T extends Enum<T>> extends ExtensibleFieldProperty<T, XStringValue> {

	public EnumFieldProperty(final String fieldIdString, final Class<T> enumClass) {
		super(fieldIdString, new Converter<T, XStringValue>() {

			@Override
			public T toJavaType(final XStringValue xydraType) {
				if (xydraType == null) {
					return null;
					// throw new
					// NullPointerException("Found a null value in field '" +
					// fieldIdString
					// + "' - cannot convert to Enum " +
					// enumClass.getCanonicalName());
				} else {
					try {
						return Enum.valueOf(enumClass, xydraType.contents());
					} catch (final IllegalArgumentException e) {
						throw new RuntimeException("Could not convert value '"
								+ xydraType.contents() + "' of type " + xydraType.getType(), e);
					}
				}
			}

			@Override
			public XStringValue toXydraValue(final T anyType) {
				return BaseRuntime.getValueFactory().createStringValue(anyType.name());
			}

		});
	}

}
