package com.calpano.common.shared.xydrautils;

import org.xydra.annotations.Template;
import org.xydra.base.XAddress;
import org.xydra.base.XId;
import org.xydra.base.rmof.XWritableObject;

/**
 * Persistence is based on an {@link XWritableObject}
 *
 * @author xamde
 */
public interface IBasedOnXWritableObject extends IBasedOnXReadableObject, IBasedOnXWritableEntity {

	/**
	 * @return the XID of the underlying {@link XWritableObject}
	 */
	@Template("Unique ID")
	@Override
	XId getId();

	/**
	 * @return the {@link XAddress} of the underlying {@link XWritableObject}
	 */
	@Override
	XAddress getAddress();

	/**
	 * @return the underlying {@link XWritableObject} itself
	 */
	XWritableObject getXWritableObject();

	/**
	 * @return the XID of the actor registered for change events
	 */
	@Override
	XId getActorId();

}
