package com.calpano.common.shared.xydrautils;

import java.io.Serializable;

import org.xydra.annotations.Template;
import org.xydra.base.XAddress;
import org.xydra.base.XId;

/**
 * Persistence is based on an X-entity
 *
 * @author xamde
 */
public interface IBasedOnXReadableEntity extends Serializable {

	/**
	 * @return the XID of the underlying X-entity
	 */
	@Template("Unique ID")
	XId getId();

	/**
	 * @return the {@link XAddress} of the underlying X-entity
	 */
	XAddress getAddress();

}
