package com.calpano.common.shared.xydrautils;

import java.util.Iterator;

import org.xydra.base.XId;
import org.xydra.index.iterator.AbstractFilteringIterator;

/**
 * Filter out all ids that are internar according to
 * {@link XydraConventions#isInternal(XId)}
 *
 * @author xamde
 *
 */
public class FilterInternalIdsIterator extends AbstractFilteringIterator<XId> implements
		Iterator<XId> {

	public FilterInternalIdsIterator(final Iterator<XId> base) {
		super(base);
	}

	@Override
	protected boolean matchesFilter(final XId entry) {
		return !XydraConventions.isInternal(entry);
	}

}
