package com.calpano.common.shared.util;

import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

/**
 * Utils to model the global runtime state of a client-side app.
 *
 * @author xamde
 *
 */
public class CommonAppState {

	@SuppressWarnings("unused")
	private static final Logger log = LoggerFactory.getLogger(CommonAppState.class);

	/**
	 * Three-values boolean. Something is either Yes, No, or Maybe (=undefined).
	 */
	public static enum Is {
		Maybe, No, Yes;

		public static Is value(final boolean b) {
			return b ? Yes : No;
		}

		public boolean isDefined() {
			return isTrue() || isFalse();
		}

		public boolean isFalse() {
			return this == No;
		}

		public boolean isTrue() {
			return this == Yes;
		}

	}

	/**
	 * A process might never have been started. Or just been started. Or it ran
	 * already and succeeded - or failed.
	 */
	public static enum Process {
		Never, Started, DoneSuccess, DoneFaillure;

		public boolean isDone() {
			return this == DoneSuccess || this == DoneFaillure;
		}
	}

}
