package com.calpano.common.shared.user.wrapper;

import java.util.Set;

import org.xydra.annotations.CanBeNull;
import org.xydra.annotations.Indexed;
import org.xydra.annotations.NeverNull;
import org.xydra.annotations.Template;

import com.calpano.common.shared.user.base.IIdentificationIndex;
import com.calpano.common.shared.xydrautils.IBasedOnXWritableObject;
import com.calpano.common.shared.xydrautils.StringSetWrapper;
import com.calpano.common.shared.xydrautils.field.FieldProperty;
import com.calpano.common.shared.xydrautils.field.StringSetFieldProperty;
import com.calpano.common.shared.xydrautils.impl.BasedOnXWritableObject;

public class IdentificationUser extends BasedOnXWritableObject implements IBasedOnXWritableObject {

	/** always initialised. */
	private static StringSetFieldProperty _alternateEmails = new StringSetFieldProperty(
			"alternateEmails");

	@Indexed("server")
	public static FieldProperty<String> _email = new FieldProperty<String>("email", String.class);

	@Indexed("server")
	public static FieldProperty<String> _username = new FieldProperty<String>("username",
			String.class);

	private static final long serialVersionUID = 1L;

	public IdentificationUser(final IBasedOnXWritableObject proto) {
		super(proto);
	}

	/**
	 * @return a potentially empty set of alternate email addresses. Main
	 *         address to send emails to is {@link #getEmail()}
	 */
	@NeverNull
	@Indexed("server")
	public Set<String> getAlternateEmailAddresses() {
		return _alternateEmails.getValue(getXWritableObject());
	}

	/**
	 * @return a wrapper around 'alternateEmails'
	 */
	@CanBeNull
	@Indexed("server")
	public StringSetWrapper getAlternateEmails() {
		// TODO Auto-generated method stub
		return null;
	}

	@Template("email address, unverified, unchecked, NOT html-sanitised, lower-cased")
	public String getEmail() {
		final String mail = _email.getValue(getXObject());
		if (mail == null) {
			return null;
		} else {
			final String m = mail.toLowerCase();
			return m;
		}
	}

	/**
	 * @return the email address if no username is explicitly defined
	 */
	@CanBeNull
	public String getUsername() {
		final String username = _username.getValue(getXObject());
		return username == null ? getEmail() : username;
	}

	/**
	 * @param email
	 *            @CanBeNull to remove any existing value
	 * @param index
	 * @throws IllegalArgumentException
	 *             if email is obviously not valid or already taken
	 */
	public void setEmail(final String email, final IIdentificationIndex index) throws IllegalArgumentException {
		assert email != null;
		assert getId() != null;

		final String currentEmail = _email.getValue(getXObject());
		index.indexEmail(getId(), currentEmail, email);
		_email.setValue(getActorId(), getXObject(), email);
	}

	/**
	 * @param username
	 *            @CanBeNull to remove any existing value
	 * @param index
	 * @throws IllegalArgumentException
	 *             if username is already taken
	 */
	public void setUsername(final String username, final IIdentificationIndex index)
			throws IllegalArgumentException {
		final String current = _username.getValue(getXObject());
		index.indexUsername(getId(), current, username);
		_username.setValue(getActorId(), getXWritableObject(), username);
	}

}
