package com.calpano.common.shared.user.base;

import java.io.Serializable;

import org.xydra.annotations.CanBeNull;
import org.xydra.annotations.NeverNull;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

import com.calpano.common.shared.mail.EmailUtils;
import com.calpano.common.shared.user.INameEmail;
import com.calpano.common.shared.user.INameEmailUser;

import de.xam.texthtml.text.TextRenderer;

/**
 * An in-memory name-email-pair
 *
 * @author xamde
 */
public class SimpleNameEmail implements INameEmail, Serializable {

	private static final Logger log = LoggerFactory.getLogger(SimpleNameEmail.class);

	private static final long serialVersionUID = -1395697742640364489L;

	public SimpleNameEmail(@CanBeNull final String name, @NeverNull final String email) {
		super();
		assert email != null;
		this.name = name;
		this.email = email.toLowerCase();
	}

	/** Just for GWT */
	protected SimpleNameEmail() {
	}

	private String name;

	private String email;

	@Override
	public String getName() {
		return TextRenderer.renderAsSafeHtml(this.name);
	}

	@Override
	public String getEmail() {
		if (!EmailUtils.isValidEmail(this.email)) {
			log.warn("Found a persisted, invalid email '" + this.email
					+ "' GA?category=warn&action=persistedInvalidEmail");
		}
		return this.email;
	}

	@Override
	public String getNameOrEmail() {
		return NameEmailUtils.getNameOrEmail(getName(), getEmail());
	}

	@Override
	public String getNameAndEmail() {
		return NameEmailUtils.getNameAndEmail(getName(), getEmail());
	}

	@Override
	public boolean equals(final Object other) {
		return other instanceof INameEmailUser
				&& ((INameEmailUser) other).getEmail().equals(getEmail());
	}

	@Override
	public int hashCode() {
		return this.email.hashCode();
	}

}
