package com.calpano.common.shared.user;

public enum AccountState {

	/** User registered herself. This state is only used in tests. */
	registered,

	/** Got a task from another user, did not confirm AGBs yet */
	delegated,

	/** Registered as a user from homepage. Did not confirm AGB yet. */
	invited,

	/** Created by admin */
	adminCreated,

	/**
	 * Created by admin for test purposes only. @deprecated use tag 'test'
	 * instead
	 */
	@Deprecated
	test,

	/** Account created in error. */
	@Deprecated
	failed,

	/** signed up for the newsletter only. */
	news;

}
