package com.calpano.common.shared.services;

import java.io.Serializable;

import org.xydra.annotations.RunsInGWT;

@RunsInGWT(true)
public class Message implements IMessage, Serializable {

	private static final long serialVersionUID = 1L;

	private final int maxRecipients;

	/**
	 * @param type
	 * @param payload
	 * @param maxRecipients
	 *            set to 1 for point-to-point messaging or -1 for broadcast. Set
	 *            to 2...n to reach at most this number of handlers.
	 */
	public Message(final String type, final byte[] payload, final int maxRecipients) {
		this.type = type;
		this.payload = payload;
		this.maxRecipients = maxRecipients;
	}

	private final String type;

	private final byte[] payload;

	@Override
	public String type() {
		return this.type;
	}

	@Override
	public byte[] payload() {
		return this.payload;
	}

	@Override
	public int maxRecipientNumber() {
		return this.maxRecipients;
	}

}
