package com.calpano.common.shared.data;

import org.xydra.base.XAddress;
import org.xydra.core.model.impl.memory.IMemoryModel;

import com.calpano.common.shared.data.DataEvent.DataEventHandler;
import com.google.web.bindery.event.shared.Event.Type;

/**
 * Part of DataManager.
 *
 * Defines which {@link DataEvent}s to listen to, and maps this to a local
 * storage key as well.
 *
 * @author alpha
 */
public class DataItemDefinition {

	private DataEvent<IMemoryModel> eventPrototype;

	private final String localStorageKeyPrefix;

	private XAddress modelAddress;

	/**
	 * @param localStorageKeyPrefix
	 *            @NeverNull
	 * @param modelAddress
	 * @param eventPrototype
	 */
	public DataItemDefinition(final String localStorageKeyPrefix, final XAddress modelAddress,
			final DataEvent<IMemoryModel> eventPrototype) {
		assert localStorageKeyPrefix != null;
		this.localStorageKeyPrefix = localStorageKeyPrefix;
		this.modelAddress = modelAddress;
		this.eventPrototype = eventPrototype;
	}

	/**
	 * @return a typed event to be used as a prototype for firing actual event
	 */
	public DataEvent<IMemoryModel> getEventPrototype() {
		return this.eventPrototype;
	}

	public Type<DataEventHandler<IMemoryModel>> getEventType() {
		return this.eventPrototype.getAssociatedType();
	}

	public String getLocalStorageKeyPrefix() {
		return this.localStorageKeyPrefix;
	}

	public XAddress getModelAddress() {
		return this.modelAddress;
	}

	public void setEventPrototype(final DataEvent<IMemoryModel> event) {
		this.eventPrototype = event;
	}

	public void setModelAddress(final XAddress modelAddress) {
		this.modelAddress = modelAddress;
	}
}
