package com.calpano.common.shared;

import org.xydra.base.Base;
import org.xydra.base.XId;
import org.xydra.conf.IConfig;
import org.xydra.conf.IConfigProvider;
import org.xydra.conf.annotations.ConfDoc;
import org.xydra.conf.annotations.ConfType;

public class ConfParamsCalpanoCommonShared implements IConfigProvider {

	@ConfType(String.class)
	@ConfDoc("e.g. 'en,de'")
	// TODO document better
	public static final String supportedLanguages = "x-supportedLanguages";

	@ConfType(XId.class)
	@ConfDoc("repository id")
	// TODO unify with xydra
	public static final String repoId = "x-repoId";

	@ConfType(Boolean.class)
	@ConfDoc("debug for GWT HTML5 stuff mostly")
	// TODO document better
	public static final String clientDebugMode = "x-debugMode";

	@Override
	public void configureDefaults(final IConfig conf) {
		conf.setDefault(clientDebugMode, "false", true);
		conf.setDefault(supportedLanguages, "en, de", true);
		conf.setDefault(repoId, Base.toId("gae-data"), true);
	}

}
