package com.calpano.common.client.view.forms.validation;

import org.xydra.annotations.Feature;

import com.calpano.common.client.view.forms.impl.Html5FormPanel;
import com.google.web.bindery.event.shared.HandlerRegistration;

/**
 * A widget that implements this interface provides registration for
 * {@link ValidationHandler} instances.
 */
public interface HasValidationHandlers {

	/**
	 * Adds a {@link ValidationEvent} handler.
	 *
	 * Register for change on valid--invalid content. The managing
	 * {@link Html5FormPanel} registers also here.
	 *
	 * @param validChangeHandler
	 *
	 * @param handler
	 * @return {@link HandlerRegistration} used to remove this handler
	 */
	@Feature("validation")
	HandlerRegistration addValidationHandler(ValidationHandler handler);

}
