package com.calpano.common.client.view.forms.utils;

import org.xydra.core.serialize.json.ParseNumber;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.EventListener;
import com.google.gwt.user.client.ui.RootPanel;

/**
 * Debugging utility for events
 *
 * @author xamde
 *
 */
public class EventUtil {

	private static final Logger log = LoggerFactory.getLogger(EventUtil.class);

	public static String dumpEvent(final Event event) {
		if (event == null) {
			return "NULL";
		}

		String target = event.getEventTarget().toString();
		target = target.substring(0, Math.min(target.length(), 40));
		target = target.replaceAll("\n", " ");

		return "EVENT " + event.toString() + "." + event.getType() + ": "

		+ " " + target

		+ (event.getKeyCode() != 0 ? " keycode = " + event.getKeyCode() : "")

		;
	}

	/** helps debugging: bit-mask to listen to ALL events */
	public static final int EVENT_ALL = Event.FOCUSEVENTS | Event.GESTUREEVENTS | Event.KEYEVENTS
			| Event.MOUSEEVENTS | Event.TOUCHEVENTS | Event.ONCHANGE | Event.ONCLICK
			| Event.ONCONTEXTMENU | ParseNumber.parseInt("11111111" + "11111111" + "11111111", 2);

	public static void main(final String[] args) {
		System.out.println(Integer.toHexString(EVENT_ALL));
		System.out.println(ParseNumber.parseInt("11111111" + "11111111" + "11111111", 2));
	}

	public static void logBrowserEvent(final Event event) {
		log.info("''''' " + dumpEvent(event));
	}

	/**
	 * All events except mouse move
	 */
	public static final int EVENT_USED = Event.KEYEVENTS | Event.FOCUSEVENTS | Event.GESTUREEVENTS
			| Event.TOUCHEVENTS | /* selected mouse events */Event.ONCLICK | Event.ONDBLCLICK
			| Event.ONMOUSEDOWN | Event.ONMOUSEUP

			/*
			 * FIXME reenable
			 *
			 * | Event.ONMOUSEOUT | Event.ONMOUSEOVER
			 */

			| Event.ONMOUSEWHEEL
			/* end selected mouse events */
			| Event.ONCONTEXTMENU | Event.ONPASTE | Event.ONCHANGE | Event.ONERROR | Event.ONLOAD
			| Event.ONLOSECAPTURE | Event.ONSCROLL;

	private static class AllListener implements EventListener {

		@Override
		public void onBrowserEvent(final Event event) {
			EventUtil.logBrowserEvent(event);
		}

	}

	/**
	 * Listen to all events defined in EVENT_USED
	 */
	public static void startEventListening() {
		listenToEvents(EVENT_USED);

		final Element body = RootPanel.getBodyElement();
		final com.google.gwt.dom.client.Element bodyElem = body;
		DOM.setEventListener(bodyElem, new AllListener());

		log.info("Event listening for debugging activated");
	}

	public static void listenToEvents(final int eventBitsToAdd) {
		RootPanel.get().sinkEvents(eventBitsToAdd);
	}

	public static void stopListenToEvents(final int eventBitsToRemove) {
		RootPanel.get().unsinkEvents(eventBitsToRemove);
	}

}
