package com.calpano.common.client.view.forms.suggestion;

import com.calpano.common.client.ClientApp;
import com.google.gwt.user.client.ui.TextBoxBase;
import com.google.web.bindery.event.shared.Event;

/**
 * Fired just before suggestions are shown.
 *
 * @author xamde
 */
public class ShowSuggestionEvent extends Event<ShowSuggestionHandler> {

	public static Type<ShowSuggestionHandler> TYPE = new Type<ShowSuggestionHandler>();

	@Override
	public Type<ShowSuggestionHandler> getAssociatedType() {
		return TYPE;
	}

	public ShowSuggestionEvent(final TextBoxBase source) {
		super();
	}

	@Override
	protected void dispatch(final ShowSuggestionHandler handler) {
		handler.onShowSuggestion(this);
	}

	@Override
	public TextBoxBase getSource() {
		return (TextBoxBase) super.getSource();
	}

	public static void fire(final TextBoxBase source) {
		ClientApp.getEventBus().fireEventFromSource(new ShowSuggestionEvent(source), source);
	}

}
