package com.calpano.common.client.view.forms.locking;

/**
 * Any widget that can lock() and unlock();
 */
public interface ILockable {

	/**
	 * Stop accepting user input on this widget.
	 */
	void lock();

	/**
	 * Start accepting user input.
	 */
	void unlock();

	/**
	 * As part of the init of the widget this method is called to make sure the
	 * widget starts with the desired lock state. Also called on widget resets.
	 */
	void resetLockState();

}
