package com.calpano.common.client.view.forms.impl;

import com.calpano.common.client.view.forms.IBelongsToHtml5Form;
import com.calpano.common.client.view.forms.IHtml5EnabledInputWidget;
import com.calpano.common.client.view.forms.suggestion.ShowHideSuggestionHandler;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.TextBoxBase;

/**
 * <h3>Public API</h3> The forms framework extends from GWTs built-in
 * {@link TextBoxBase}, {@link TextArea} and {@link TextBox}.
 *
 * A container, the {@link Html5FormPanel} contains {@link Html5TextBox} and
 * {@link Html5TextArea} inputs as well as 0 or more {@link Html5SubmitButton}.
 *
 * {@link Html5TextBox} extends {@link TextBox} and implements
 * {@link IHtml5EnabledInputWidget}, {@link IBelongsToHtml5Form},
 * {@link ShowHideSuggestionHandler}.
 *
 * {@link Html5TextArea} extends {@link TextArea} and implements
 * {@link IHtml5EnabledInputWidget}, {@link IBelongsToHtml5Form}.
 *
 * Both provide:
 *
 * TextBoxBase asHtml5TextInput().getTextBoxBase();
 *
 * void asHtml5TextInput().reset();
 *
 * Activation
 * <ul>
 * <li>
 * HasActivationHandlers
 * <li>
 * HasDeactivationHandlers
 * </ul>
 *
 * Placeholder
 * <ul>
 * <li>
 * String getText();
 * <li>
 * String asHtml5TextInput().getRawText();
 * <li>
 * void asHtml5TextInput().setRawText(String s);
 * </ul>
 *
 * Validation
 * <ul>
 * <li>HasValidationHandlers, HasInvaliationHandlers
 * <li>
 * asHtml5TextInput().setRequired(boolean value);
 * <li>
 * boolean asHtml5TextInput().isRequired();
 * <li>
 * void asHtml5TextInput().addValidator(Integer order, IStringValidator
 * validator);
 * <li>
 * ValidationMessage asHtml5TextInput().computeValidation();
 * <li>
 * String asHtml5TextInput().getType();
 * <li>
 * void asHtml5TextInput().activateValidationWarnings();
 * </ul>
 *
 * Suggestions
 * <ul>
 * <li>
 * void setAutocomplete(String onOrOff);
 * <li>
 * boolean isShowingSuggestions();
 * </ul>
 *
 * <h3>Implementation Strategy</h3> {@link Html5TextBox} and
 * {@link Html5TextArea} both delegate most work to
 * {@link Html5TextBoxAndAreaPart}.
 *
 *
 * @author xamde
 */
public interface Documentation {

}
