package com.calpano.common.client.view.forms.activation;

import com.google.web.bindery.event.shared.HandlerRegistration;

/**
 * A widget that implements this interface provides registration for
 * {@link DeactivationHandler} instances.
 */
public interface HasDeactivationHandlers {
	/**
	 * Adds a {@link DeactivationEvent} handler.
	 *
	 * @param handler
	 * @return {@link HandlerRegistration} used to remove this handler
	 */
	HandlerRegistration addDeactivationHandler(DeactivationHandler handler);
}
