package com.calpano.common.client.view.forms;

import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

import com.calpano.common.client.util.IStringTransformer;

/**
 * Static, but statefull.
 *
 * Allows to register a {@link IStringTransformer} which treats all strings as
 * p13n keys and returns the unrolled strings.
 *
 * @author xamde
 */
public class StaticFormManager {

	private static final Logger log = LoggerFactory.getLogger(StaticFormManager.class);

	private static final IStringTransformer TRIVIAL_TRANSFORMER = new IStringTransformer() {

		@Override
		public String transform(final String raw) {
			/* trivial transformer that wraps 'null' to a String */
			return "" + raw;
		}
	};

	private static IStringTransformer stringTransformer_ = TRIVIAL_TRANSFORMER;

	/**
	 * Register an {@link IStringTransformer} for rendering validation errors.
	 *
	 * @param stringTransformer
	 */
	public static void registerStringTransformer(final IStringTransformer stringTransformer) {
		stringTransformer_ = stringTransformer;
	}

	public static IStringTransformer getStringTransformer() {
		if (stringTransformer_ == TRIVIAL_TRANSFORMER) {
			log.warn(/* WARN */"No stringTransformer has been set");
		}
		return stringTransformer_;
	}

}
