package com.calpano.common.client.view.forms;

import com.calpano.common.client.util.Callback;
import com.calpano.common.client.view.forms.impl.Html5FormPanel;
import com.calpano.common.client.view.forms.impl.Html5SubmitButton;

/**
 * Submits the form. Make sure to call this {@link Html5FormPanel} as a
 * {@link Callback} when the submit is done.
 */
public interface IFormManagingWidget {

	/**
	 * Submits the form via AJAX or whatever.
	 *
	 * Is called when the {@link Html5SubmitButton} of the
	 * {@link Html5FormPanel} is activated.
	 *
	 * Make sure to call this {@link Html5FormPanel} as a {@link Callback} when
	 * the submit is done.
	 */
	void submitForm();

}
