package com.calpano.common.client.view.forms;

import com.calpano.common.client.view.forms.impl.Html5FormPanel;

/**
 * A widget that belongs to an {@link Html5FormPanel}.
 *
 * When a form is created it automatically gathers all
 * {@link IBelongsToHtml5Form} parts from the widget hierarchy and does the
 * linking.
 */
public interface IBelongsToHtml5Form {

	/**
	 * @param form
	 *            to which this input element or button belongs.
	 */
	public void setForm(Html5FormPanel form);

	/**
	 * @return the form to which this input element or button belongs.
	 */
	public Html5FormPanel getForm();

}
