package com.calpano.common.client.util;

import org.xydra.annotations.RunsInGWT;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

import com.google.gwt.user.client.Window;

/**
 * Internet Explorer version for PushState. As there is no pushState, it does a
 * page reload. This leaves sensitive URL data in the browser history.
 *
 * FIXME find better workaround for login URL
 *
 * @author xamde
 */
@RunsInGWT(true)
public class PushStateIE extends PushState {

	private static final Logger log = LoggerFactory.getLogger(PushStateIE.class);

	@Override
	public void pushState(final String data, final String title, final String url,
			final boolean reloadPageIfPushStateUnsupported) {
		if (reloadPageIfPushStateUnsupported) {
			setUrl(url);
		}
	}

	private static void setUrl(final String url) {
		final String currentLocation = Window.Location.getHref();
		if (!currentLocation.equals(url)) {
			Window.Location.assign(url);
		} else {
			log.info("We are already on '" + currentLocation + "' so no need to reload.");
		}
	}

	@Override
	public void pushStateNoData(final String title, final String url, final boolean reloadPageIfPushStateUnsupported) {
		if (reloadPageIfPushStateUnsupported) {
			setUrl(url);
		}
	}

	@Override
	public void pushStateNoData(final String url, final boolean reloadPageIfPushStateUnsupported) {
		if (reloadPageIfPushStateUnsupported) {
			setUrl(url);
		}
	}

	@Override
	public void replaceStateNoData(final String url, final boolean reloadPageIfPushStateUnsupported) {
		if (reloadPageIfPushStateUnsupported) {
			setUrl(url);
		}
	}

	@Override
	public void replaceState(final String data, final String title, final String url,
			final boolean reloadPageIfPushStateUnsupported) {
		if (reloadPageIfPushStateUnsupported) {
			setUrl(url);
		}
	}

	@Override
	public void replaceStateNoData(final String title, final String url,
			final boolean reloadPageIfPushStateUnsupported) {
		if (reloadPageIfPushStateUnsupported) {
			setUrl(url);
		}
	}
}
