/*
 * Based on Code under this license: ---------------------------------------
 *
 * Copyright 2011 Daniel Kurka
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.calpano.common.client.history;

import org.xydra.annotations.LicenseApache;

import com.google.web.bindery.event.shared.EventBus;
import com.google.web.bindery.event.shared.HandlerRegistration;
import com.google.web.bindery.event.shared.SimpleEventBus;

@LicenseApache(copyright = "Copyright 2011 Daniel Kurka")
@Deprecated
public class HistoryHandler {

	private final EventBus eventBus = new SimpleEventBus();

	public HistoryHandler() {
		bind();
	}

	private native void bind() /*-{
								var that = this;

								var f = function(event) {
								that.@de.xam.mybase.desktop.ui.client.HistoryHandler::onUrlEvent(Ljava/lang/String;)(event.url);
								};

								$wnd.addEventListener('popstate', $entry(f));

								}-*/;

	// called from js
	protected void onUrlEvent(final String url) {
		this.eventBus.fireEvent(new UrlEvent(url));
	}

	public native void forward() /*-{
									$wnd.history.forward();
									}-*/;

	public native void back() /*-{
								$wnd.history.back();
								}-*/;

	public native void go(int number) /*-{
										$wnd.history.go(number);
										}-*/;

	public native int length() /*-{
								return $wnd.history.length;
								}-*/;

	public native void pushState(String data, String title, String url) /*-{
																		$wnd.history.pushState(data, title, url);
																		}-*/;

	public native void replaceState(String data, String title, String url) /*-{
																			$wnd.history.replaceState(data, title, url);
																			}-*/;

	public HandlerRegistration addUrlEventHandler(final UrlEventHandler handler) {
		return this.eventBus.addHandler(UrlEvent.getType(), handler);

	}

	protected native String decodeFragment(String encodedFragment) /*-{
																	// decodeURI() does *not* decode the '#' character.
																	return decodeURI(encodedFragment.replace("%23", "#"));
																	}-*/;

	protected native String encodeFragment(String fragment) /*-{
															// encodeURI() does *not* encode the '#' character.
															return encodeURI(fragment).replace("#", "%23");
															}-*/;

}
