/*
 * Decompiled with CFR 0.152.
 */
package de.xam.packagechaos.architecture;

import de.xam.packagechaos.Package;
import java.util.HashSet;
import java.util.Set;

public class Layer {
    private final String commonPackagePrefix;
    private final Set<Layer> lowerLayers = new HashSet<Layer>();
    private boolean allowFromAll;
    private boolean allowToAll;

    public Layer(String commonPackagePrefix, boolean allowFromAll, boolean allowToAll) {
        this.commonPackagePrefix = commonPackagePrefix;
        this.allowFromAll = allowFromAll;
        this.allowToAll = allowToAll;
    }

    public int hashCode() {
        return this.commonPackagePrefix.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof Layer && ((Layer)o).commonPackagePrefix.equals(this.commonPackagePrefix);
    }

    public void mayAccess(Layer ... lower) {
        if (lower != null) {
            for (Layer l : lower) {
                this.lowerLayers.add(l);
            }
        }
    }

    public boolean contains(Package p) {
        return p.getName().contains(this.commonPackagePrefix);
    }

    public Set<Layer> getLowerLayers() {
        return this.lowerLayers;
    }

    public boolean hasAccessToAllPackages() {
        return this.allowToAll;
    }

    public boolean canBeAccessedFromAllPackages() {
        return this.allowFromAll;
    }

    public String toString() {
        return this.commonPackagePrefix + "*";
    }

    public void setAllowAccessFromEveryPackage(boolean b) {
        this.allowFromAll = b;
    }

    public void setAllowAccessToEveryPackage(boolean b) {
        this.allowToAll = b;
    }
}

