/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.worker;

import com.google.caliper.api.AfterRep;
import com.google.caliper.api.BeforeRep;
import com.google.caliper.model.Measurement;
import com.google.caliper.model.Value;
import com.google.caliper.runner.Running;
import com.google.caliper.util.Reflection;
import com.google.caliper.util.Util;
import com.google.caliper.worker.Worker;
import com.google.caliper.worker.WorkerOptions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class MacrobenchmarkWorker
extends Worker {
    private final Stopwatch stopwatch;
    private final ImmutableSet<Method> beforeRepMethods;
    private final ImmutableSet<Method> afterRepMethods;
    private final boolean gcBeforeEach;

    @Inject
    MacrobenchmarkWorker(@Running.Benchmark Object benchmark, @Running.BenchmarkMethod Method method, Ticker ticker, @WorkerOptions Map<String, String> workerOptions) {
        super(benchmark, method);
        this.stopwatch = Stopwatch.createUnstarted((Ticker)ticker);
        this.beforeRepMethods = Reflection.getAnnotatedMethods(benchmark.getClass(), BeforeRep.class);
        this.afterRepMethods = Reflection.getAnnotatedMethods(benchmark.getClass(), AfterRep.class);
        this.gcBeforeEach = Boolean.parseBoolean(workerOptions.get("gcBeforeEach"));
    }

    @Override
    public void preMeasure() throws Exception {
        for (Method beforeRepMethod : this.beforeRepMethods) {
            beforeRepMethod.invoke(this.benchmark, new Object[0]);
        }
        if (this.gcBeforeEach) {
            Util.forceGc();
        }
    }

    @Override
    public Iterable<Measurement> measure() throws Exception {
        this.stopwatch.start();
        this.benchmarkMethod.invoke(this.benchmark, new Object[0]);
        long nanos = this.stopwatch.stop().elapsed(TimeUnit.NANOSECONDS);
        this.stopwatch.reset();
        return ImmutableSet.of((Object)new Measurement.Builder().description("runtime").weight(1.0).value(Value.create(nanos, "ns")).build());
    }

    @Override
    public void postMeasure() throws Exception {
        for (Method afterRepMethod : this.afterRepMethods) {
            afterRepMethod.invoke(this.benchmark, new Object[0]);
        }
    }
}

