/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.worker;

import com.google.caliper.model.Measurement;
import com.google.caliper.model.Value;
import com.google.caliper.worker.Allocation;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.util.Collection;

class AllocationStats {
    private final int allocationCount;
    private final long allocationSize;
    private final int reps;
    private final ImmutableMultiset<Allocation> allocations;

    AllocationStats(int allocationCount, long allocationSize, int reps) {
        this(allocationCount, allocationSize, reps, (Multiset<Allocation>)ImmutableMultiset.of());
    }

    AllocationStats(Collection<Allocation> allocations, int reps) {
        this(allocations.size(), Allocation.getTotalSize(allocations), reps, (Multiset<Allocation>)ImmutableMultiset.copyOf(allocations));
    }

    private AllocationStats(int allocationCount, long allocationSize, int reps, Multiset<Allocation> allocations) {
        Preconditions.checkArgument((allocationCount >= 0 ? 1 : 0) != 0, (String)"allocationCount (%s) was negative", (Object[])new Object[]{allocationCount});
        this.allocationCount = allocationCount;
        Preconditions.checkArgument((allocationSize >= 0L ? 1 : 0) != 0, (String)"allocationSize (%s) was negative", (Object[])new Object[]{allocationSize});
        this.allocationSize = allocationSize;
        Preconditions.checkArgument((reps >= 0 ? 1 : 0) != 0, (String)"reps (%s) was negative", (Object[])new Object[]{reps});
        this.reps = reps;
        this.allocations = Multisets.copyHighestCountFirst(allocations);
    }

    int getAllocationCount() {
        return this.allocationCount;
    }

    long getAllocationSize() {
        return this.allocationSize;
    }

    AllocationStats minus(AllocationStats baseline) {
        for (Multiset.Entry entry : baseline.allocations.entrySet()) {
            int superCount = this.allocations.count(entry.getElement());
            if (superCount >= entry.getCount()) continue;
            throw new IllegalStateException(String.format("Your benchmark appears to have non-deterministic allocation behavior. Observed %d instance(s) of %s in the baseline but only %d in the actual measurement", entry.getCount(), entry.getElement(), superCount));
        }
        try {
            return new AllocationStats(this.allocationCount - baseline.allocationCount, this.allocationSize - baseline.allocationSize, this.reps - baseline.reps, (Multiset<Allocation>)Multisets.difference(this.allocations, baseline.allocations));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(String.format("Your benchmark appears to have non-deterministic allocation behavior. The difference between the baseline %s and the measurement %s is invalid. Consider enabling instrument.allocation.options.trackAllocations to get a more specific error message.", baseline, this), e);
        }
    }

    ImmutableList<Measurement> toMeasurements() {
        for (Multiset.Entry entry : this.allocations.entrySet()) {
            double allocsPerRep = (double)entry.getCount() / (double)this.reps;
            System.out.printf("Allocated %f allocs per rep of %s%n", allocsPerRep, entry.getElement());
        }
        return ImmutableList.of((Object)new Measurement.Builder().value(Value.create(this.allocationCount, "")).description("objects").weight(this.reps).build(), (Object)new Measurement.Builder().value(Value.create(this.allocationSize, "B")).weight(this.reps).description("bytes").build());
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("allocationCount", this.allocationCount).add("allocationSize", this.allocationSize).add("reps", this.reps).toString();
    }
}

