/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner;

import com.google.caliper.runner.Experiment;
import com.google.caliper.runner.TrialId;
import com.google.caliper.runner.TrialNumber;
import com.google.caliper.runner.TrialScoped;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.inject.AbstractModule;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.OutOfScopeException;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.google.inject.Scope;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;

class TrialScopes {
    private static final ThreadLocal<TrialContext> contextLocal = new ThreadLocal();
    private static final Scope SCOPE = new Scope(){

        public <T> Provider<T> scope(final Key<T> key, final Provider<T> unscoped) {
            return new Provider<T>(){

                public T get() {
                    TrialContext context = (TrialContext)contextLocal.get();
                    if (context == null) {
                        throw new OutOfScopeException("Not currently in TrialScope");
                    }
                    try {
                        Object value = context.contextMap.get((Object)key, new Callable<T>(){

                            @Override
                            public T call() throws Exception {
                                return unscoped.get();
                            }
                        });
                        return value;
                    }
                    catch (ExecutionException e) {
                        throw new ProvisionException("Unable to provide: " + key, e.getCause());
                    }
                }
            };
        }
    };
    private static final Module INTERNAL = new AbstractModule(){

        protected void configure() {
            this.bindScope(TrialScoped.class, SCOPE);
            this.bindSeedKey(Key.get(UUID.class, TrialId.class));
            this.bindSeedKey(Key.get(Integer.class, TrialNumber.class));
            this.bindSeedKey(Key.get(Experiment.class));
        }

        private <T> void bindSeedKey(final Key<T> key) {
            this.bind(key).toProvider(new Provider<T>(){

                public T get() {
                    throw new OutOfScopeException(key + " is not available because you are not in a TrialScope");
                }
            }).in(TrialScoped.class);
        }
    };

    TrialScopes() {
    }

    static Module module() {
        return INTERNAL;
    }

    static TrialContext makeContext(UUID trialId, int trialNumber, Experiment experiment) {
        return new TrialContext(trialId, trialNumber, experiment);
    }

    static final class TrialContext {
        private final Cache<Key<?>, Object> contextMap = CacheBuilder.newBuilder().concurrencyLevel(1).build();

        private TrialContext(UUID trialId, int trialNumber, Experiment experiment) {
            this.contextMap.put((Object)Key.get(UUID.class, TrialId.class), (Object)trialId);
            this.contextMap.put((Object)Key.get(Integer.class, TrialNumber.class), (Object)trialNumber);
            this.contextMap.put((Object)Key.get(Experiment.class), (Object)experiment);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        <T> T call(Callable<T> callable) throws Exception {
            if (contextLocal.get() != null) {
                throw new IllegalStateException("Already in TrialScope");
            }
            contextLocal.set(this);
            try {
                T t = callable.call();
                return t;
            }
            finally {
                contextLocal.remove();
            }
        }
    }
}

