/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner;

import com.google.caliper.bridge.CaliperControlLogMessage;
import com.google.caliper.bridge.LogMessage;
import com.google.caliper.options.CaliperOptions;
import com.google.caliper.runner.ServerSocketService;
import com.google.caliper.runner.TrialNumber;
import com.google.caliper.runner.TrialScoped;
import com.google.caliper.runner.WorkerProcess;
import com.google.caliper.util.Parser;
import com.google.caliper.util.Stdout;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Queues;
import com.google.common.io.Closeables;
import com.google.common.io.LineReader;
import com.google.common.util.concurrent.AbstractService;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Service;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import javax.annotation.Nullable;

@TrialScoped
final class StreamService
extends AbstractService {
    private static final int SHUTDOWN_WAIT_MILLIS = 10;
    private static final Logger logger = Logger.getLogger(StreamService.class.getName());
    private static final StreamItem TIMEOUT_ITEM = new StreamItem(StreamItem.Kind.TIMEOUT, null);
    private static final StreamItem EOF_ITEM = new StreamItem(StreamItem.Kind.EOF, null);
    private final ListeningExecutorService streamExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).build()));
    private final BlockingQueue<StreamItem> outputQueue = Queues.newLinkedBlockingQueue();
    private final WorkerProcess worker;
    private volatile Process process;
    private final Parser<LogMessage> logMessageParser;
    private final CaliperOptions options;
    private final PrintWriter stdout;
    private final int trialNumber;
    private final AtomicInteger openStreams = new AtomicInteger();
    private final AtomicInteger runningReadStreams = new AtomicInteger();
    private Writer socketWriter;

    @Inject
    StreamService(WorkerProcess worker, @TrialNumber int trialNumber, Parser<LogMessage> logMessageParser, CaliperOptions options, @Stdout PrintWriter stdout) {
        this.worker = worker;
        this.trialNumber = trialNumber;
        this.logMessageParser = logMessageParser;
        this.options = options;
        this.stdout = stdout;
    }

    protected void doStart() {
        try {
            this.process = this.worker.startWorker();
        }
        catch (IOException e) {
            this.notifyFailed(e);
            return;
        }
        this.addListener(new Service.Listener(){

            public void starting() {
            }

            public void running() {
            }

            public void stopping(Service.State from) {
            }

            public void terminated(Service.State from) {
                this.cleanup();
            }

            public void failed(Service.State from, Throwable failure) {
                this.cleanup();
            }

            void cleanup() {
                StreamService.this.streamExecutor.shutdown();
                StreamService.this.process.destroy();
                try {
                    StreamService.this.streamExecutor.awaitTermination(10L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                StreamService.this.streamExecutor.shutdownNow();
            }
        }, (Executor)MoreExecutors.sameThreadExecutor());
        Charset processCharset = Charset.defaultCharset();
        this.runningReadStreams.addAndGet(2);
        this.openStreams.addAndGet(1);
        this.streamExecutor.submit(StreamService.threadRenaming("worker-stderr", new StreamReader(new InputStreamReader(this.process.getErrorStream(), processCharset))));
        this.streamExecutor.submit(StreamService.threadRenaming("worker-stdout", new StreamReader(new InputStreamReader(this.process.getInputStream(), processCharset))));
        this.worker.socketFuture().addListener(new Runnable(){

            @Override
            public void run() {
                try {
                    ServerSocketService.OpenedSocket openedSocket = (ServerSocketService.OpenedSocket)StreamService.this.worker.socketFuture().get();
                    logger.fine("successfully opened the pipe from the worker");
                    StreamService.this.socketWriter = openedSocket.writer();
                    StreamService.this.runningReadStreams.addAndGet(1);
                    StreamService.this.openStreams.addAndGet(1);
                    StreamService.this.streamExecutor.submit(StreamService.threadRenaming("worker-socket", new StreamReader(openedSocket.reader())));
                }
                catch (ExecutionException e) {
                    StreamService.this.notifyFailed(e.getCause());
                }
                catch (InterruptedException e) {
                    throw new AssertionError((Object)"impossible, future is already done.");
                }
            }
        }, (Executor)MoreExecutors.sameThreadExecutor());
        this.notifyStarted();
    }

    StreamItem readItem(long timeout, TimeUnit unit) throws InterruptedException {
        Preconditions.checkState((boolean)this.isRunning(), (String)"Cannot read items from a %s StreamService", (Object[])new Object[]{this.state()});
        StreamItem line = this.outputQueue.poll(timeout, unit);
        if (line == EOF_ITEM) {
            this.closeStream();
        }
        return line == null ? TIMEOUT_ITEM : line;
    }

    void writeLine(String line) throws IOException {
        Preconditions.checkState((boolean)this.isRunning(), (String)"Cannot read items from a %s StreamService", (Object[])new Object[]{this.state()});
        Preconditions.checkState((this.socketWriter != null ? 1 : 0) != 0, (Object)"Attempted to write to the socket before it was opened.");
        try {
            this.socketWriter.write(line);
            this.socketWriter.write(10);
            this.socketWriter.flush();
        }
        catch (IOException e) {
            Closeables.close((Closeable)this.socketWriter, (boolean)true);
            this.notifyFailed(e);
            throw e;
        }
    }

    void closeWriter() throws IOException {
        Preconditions.checkState((boolean)this.isRunning(), (String)"Cannot read items from a %s StreamService", (Object[])new Object[]{this.state()});
        Preconditions.checkState((this.socketWriter != null ? 1 : 0) != 0, (Object)"Attempted to close the socket before it was opened.");
        try {
            this.socketWriter.close();
        }
        catch (IOException e) {
            this.notifyFailed(e);
            throw e;
        }
        this.closeStream();
    }

    protected void doStop() {
        if (this.openStreams.get() > 0) {
            logger.warning("Attempting to stop the stream service with streams still open");
        }
        final ListenableFuture processFuture = this.streamExecutor.submit((Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return StreamService.this.process.waitFor();
            }
        });
        this.streamExecutor.submit((Callable)new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                boolean threw = true;
                try {
                    if ((Integer)processFuture.get(10L, TimeUnit.MILLISECONDS) == 0) {
                        StreamService.this.notifyStopped();
                    } else {
                        StreamService.this.notifyFailed(new Exception("Process failed to stop cleanly. Exit code: " + StreamService.this.process.waitFor()));
                    }
                    threw = false;
                }
                finally {
                    processFuture.cancel(true);
                    if (threw) {
                        StreamService.this.process.destroy();
                        StreamService.this.notifyFailed(new Exception("Process failed to stop cleanly and was forcibly killed. Exit code: " + StreamService.this.process.waitFor()));
                    }
                }
                return null;
            }
        });
    }

    private void closeStream() {
        if (this.openStreams.decrementAndGet() == 0) {
            this.stopAsync();
        }
    }

    private void closeReadStream() {
        if (this.runningReadStreams.decrementAndGet() == 0) {
            this.outputQueue.add(EOF_ITEM);
        }
    }

    private static <T> Callable<T> threadRenaming(final String name, final Callable<T> callable) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull(callable);
        return new Callable<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T call() throws Exception {
                Thread currentThread = Thread.currentThread();
                String oldName = currentThread.getName();
                currentThread.setName(name);
                try {
                    Object v = callable.call();
                    return v;
                }
                finally {
                    currentThread.setName(oldName);
                }
            }
        };
    }

    private final class StreamReader
    implements Callable<Void> {
        final Reader reader;

        StreamReader(Reader reader) {
            this.reader = reader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws IOException, InterruptedException, ParseException {
            LineReader lineReader = new LineReader((Readable)this.reader);
            boolean threw = true;
            try {
                String line;
                while ((line = lineReader.readLine()) != null) {
                    LogMessage logMessage = (LogMessage)StreamService.this.logMessageParser.parse(line);
                    if (StreamService.this.options.verbose() && !(logMessage instanceof CaliperControlLogMessage)) {
                        StreamService.this.stdout.printf("[trial-%d] %s%n", StreamService.this.trialNumber, line);
                    }
                    StreamService.this.outputQueue.put(new StreamItem(logMessage));
                }
                threw = false;
            }
            catch (IOException e) {
                StreamService.this.notifyFailed(e);
            }
            finally {
                StreamService.this.closeReadStream();
                Closeables.close((Closeable)this.reader, (boolean)threw);
            }
            return null;
        }
    }

    static class StreamItem {
        @Nullable
        private final LogMessage logMessage;
        private final Kind kind;

        private StreamItem(LogMessage line) {
            this(Kind.DATA, (LogMessage)Preconditions.checkNotNull((Object)line));
        }

        private StreamItem(Kind state, @Nullable LogMessage logMessage) {
            this.logMessage = logMessage;
            this.kind = state;
        }

        LogMessage content() {
            Preconditions.checkState((this.kind == Kind.DATA ? 1 : 0) != 0, (Object)"Only data lines have content");
            return this.logMessage;
        }

        Kind kind() {
            return this.kind;
        }

        public String toString() {
            Objects.ToStringHelper helper = Objects.toStringHelper(StreamItem.class);
            if (this.kind == Kind.DATA) {
                helper.addValue((Object)this.logMessage);
            } else {
                helper.addValue((Object)this.kind);
            }
            return helper.toString();
        }

        static enum Kind {
            EOF,
            TIMEOUT,
            DATA;

        }
    }
}

