/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner;

import com.google.caliper.bridge.StartupAnnounceMessage;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.google.common.util.concurrent.AbstractExecutionThreadService;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.gson.Gson;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.GuardedBy;

@Singleton
class ServerSocketService
extends AbstractExecutionThreadService {
    private final Lock lock = new ReentrantLock();
    @GuardedBy(value="lock")
    private final Map<UUID, SettableFuture<OpenedSocket>> halfFinishedConnections = Maps.newHashMap();
    @GuardedBy(value="lock")
    private final SetMultimap<Source, UUID> connectionState = MultimapBuilder.enumKeys(Source.class).hashSetValues().build();
    private ServerSocket serverSocket;
    private final Gson gson;

    @Inject
    ServerSocketService(Gson gson) {
        this.gson = gson;
    }

    int getPort() {
        this.awaitRunning();
        Preconditions.checkState((this.serverSocket != null ? 1 : 0) != 0, (Object)"Socket has not been opened yet");
        return this.serverSocket.getLocalPort();
    }

    public ListenableFuture<OpenedSocket> getConnection(UUID id) {
        Preconditions.checkState((boolean)this.isRunning(), (String)"You can only get connections from a running service: %s", (Object[])new Object[]{this});
        return this.getConnectionImpl(id, Source.REQUEST);
    }

    protected void startUp() throws Exception {
        this.serverSocket = new ServerSocket(0);
    }

    protected void run() throws Exception {
        while (this.isRunning()) {
            Socket socket;
            try {
                socket = this.serverSocket.accept();
            }
            catch (SocketException e) {
                return;
            }
            OpenedSocket openedSocket = OpenedSocket.fromSocket(socket);
            UUID id = ((StartupAnnounceMessage)this.gson.fromJson(openedSocket.reader().readLine(), StartupAnnounceMessage.class)).trialId();
            this.getConnectionImpl(id, Source.ACCEPT).set((Object)openedSocket);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SettableFuture<OpenedSocket> getConnectionImpl(UUID id, Source source) {
        this.lock.lock();
        try {
            Preconditions.checkState((boolean)this.connectionState.put((Object)source, (Object)id), (String)"Connection for %s has already been %s", (Object[])new Object[]{id, source});
            SettableFuture future = this.halfFinishedConnections.get(id);
            if (future == null) {
                future = SettableFuture.create();
                this.halfFinishedConnections.put(id, (SettableFuture<OpenedSocket>)future);
            } else {
                this.halfFinishedConnections.remove(id);
            }
            SettableFuture settableFuture = future;
            return settableFuture;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void triggerShutdown() {
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutDown() throws Exception {
        this.serverSocket.close();
        this.lock.lock();
        try {
            for (SettableFuture<OpenedSocket> future : this.halfFinishedConnections.values()) {
                future.setException((Throwable)new Exception("The socket has been closed"));
            }
            this.halfFinishedConnections.clear();
            this.connectionState.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    private static OutputStream getOutputStream(final Socket socket) throws IOException {
        final OutputStream delegate = socket.getOutputStream();
        return new OutputStream(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                delegate.flush();
                Socket socket2 = socket;
                synchronized (socket2) {
                    socket.shutdownOutput();
                    if (socket.isInputShutdown()) {
                        socket.close();
                    }
                }
            }

            @Override
            public void write(int b) throws IOException {
                delegate.write(b);
            }

            @Override
            public void write(byte[] b) throws IOException {
                delegate.write(b);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                delegate.write(b, off, len);
            }

            @Override
            public void flush() throws IOException {
                delegate.flush();
            }
        };
    }

    private static InputStream getInputStream(final Socket socket) throws IOException {
        final InputStream delegate = socket.getInputStream();
        return new InputStream(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                Socket socket2 = socket;
                synchronized (socket2) {
                    socket.shutdownInput();
                    if (socket.isOutputShutdown()) {
                        socket.close();
                    }
                }
            }

            @Override
            public int read() throws IOException {
                return delegate.read();
            }

            @Override
            public int read(byte[] b) throws IOException {
                return delegate.read(b);
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                return delegate.read(b, off, len);
            }

            @Override
            public long skip(long n) throws IOException {
                return delegate.skip(n);
            }

            @Override
            public int available() throws IOException {
                return delegate.available();
            }

            @Override
            public void mark(int readlimit) {
                delegate.mark(readlimit);
            }

            @Override
            public void reset() throws IOException {
                delegate.reset();
            }

            @Override
            public boolean markSupported() {
                return delegate.markSupported();
            }
        };
    }

    static final class OpenedSocket {
        private final BufferedReader reader;
        private final Writer writer;

        @VisibleForTesting
        static OpenedSocket fromSocket(Socket socket) throws IOException {
            socket.setTcpNoDelay(true);
            return new OpenedSocket(new OutputStreamWriter(ServerSocketService.getOutputStream(socket), Charsets.UTF_8), new BufferedReader(new InputStreamReader(ServerSocketService.getInputStream(socket), Charsets.UTF_8)));
        }

        private OpenedSocket(Writer writer, BufferedReader reader) {
            this.reader = reader;
            this.writer = writer;
        }

        BufferedReader reader() {
            return this.reader;
        }

        Writer writer() {
            return this.writer;
        }
    }

    private static enum Source {
        REQUEST,
        ACCEPT;

    }
}

