/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner;

import com.google.caliper.Benchmark;
import com.google.caliper.api.AfterRep;
import com.google.caliper.api.BeforeRep;
import com.google.caliper.api.Macrobenchmark;
import com.google.caliper.api.SkipThisScenarioException;
import com.google.caliper.bridge.AbstractLogMessageVisitor;
import com.google.caliper.bridge.GcLogMessage;
import com.google.caliper.bridge.HotspotLogMessage;
import com.google.caliper.bridge.StartMeasurementLogMessage;
import com.google.caliper.bridge.StopMeasurementLogMessage;
import com.google.caliper.model.Measurement;
import com.google.caliper.runner.BenchmarkMethods;
import com.google.caliper.runner.Instrument;
import com.google.caliper.runner.InvalidBenchmarkException;
import com.google.caliper.runner.NanoTimeGranularity;
import com.google.caliper.runner.TrialFailureException;
import com.google.caliper.runner.UserCodeException;
import com.google.caliper.util.Reflection;
import com.google.caliper.util.ShortDuration;
import com.google.caliper.util.Stderr;
import com.google.caliper.util.Stdout;
import com.google.caliper.util.Util;
import com.google.caliper.worker.MacrobenchmarkWorker;
import com.google.caliper.worker.RuntimeWorker;
import com.google.caliper.worker.Worker;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

class RuntimeInstrument
extends Instrument {
    private static final String SUGGEST_GRANULARITY_OPTION = "suggestGranularity";
    private static final String TIMING_INTERVAL_OPTION = "timingInterval";
    private static final int DRY_RUN_REPS = 1;
    private static final Logger logger = Logger.getLogger(RuntimeInstrument.class.getName());
    private final PrintWriter stdout;
    private final PrintWriter stderr;
    private final ShortDuration nanoTimeGranularity;

    @Inject
    RuntimeInstrument(@NanoTimeGranularity ShortDuration nanoTimeGranularity, @Stdout PrintWriter stdout, @Stderr PrintWriter stderr) {
        this.nanoTimeGranularity = nanoTimeGranularity;
        this.stdout = stdout;
        this.stderr = stderr;
    }

    @Override
    public boolean isBenchmarkMethod(Method method) {
        return method.isAnnotationPresent(Benchmark.class) || BenchmarkMethods.isTimeMethod(method) || method.isAnnotationPresent(Macrobenchmark.class);
    }

    @Override
    protected ImmutableSet<String> instrumentOptions() {
        return ImmutableSet.of((Object)"warmup", (Object)TIMING_INTERVAL_OPTION, (Object)"measurements", (Object)"gcBeforeEach", (Object)SUGGEST_GRANULARITY_OPTION);
    }

    @Override
    public Instrument.Instrumentation createInstrumentation(Method benchmarkMethod) throws InvalidBenchmarkException {
        Preconditions.checkNotNull((Object)benchmarkMethod);
        Preconditions.checkArgument((boolean)this.isBenchmarkMethod(benchmarkMethod));
        if (Util.isStatic(benchmarkMethod)) {
            throw new InvalidBenchmarkException("Benchmark methods must not be static: %s", benchmarkMethod.getName());
        }
        try {
            switch (BenchmarkMethods.Type.of(benchmarkMethod)) {
                case MACRO: {
                    return new MacrobenchmarkInstrumentation(benchmarkMethod);
                }
                case MICRO: {
                    return new MicrobenchmarkInstrumentation(benchmarkMethod);
                }
                case PICO: {
                    return new PicobenchmarkInstrumentation(benchmarkMethod);
                }
            }
            throw new AssertionError((Object)"unknown type");
        }
        catch (IllegalArgumentException e) {
            throw new InvalidBenchmarkException("Benchmark methods must have no arguments or accept a single int or long parameter: %s", benchmarkMethod.getName());
        }
    }

    private int getMeasurementsPerTrial() {
        String measurementsString = (String)this.options.get((Object)"measurements");
        int measurementsPerTrial = measurementsString == null ? 1 : Integer.parseInt(measurementsString);
        Preconditions.checkState((measurementsPerTrial > 0 ? 1 : 0) != 0);
        return measurementsPerTrial;
    }

    private final class SingleInvocationMeasurementCollector
    extends RuntimeMeasurementCollector {
        SingleInvocationMeasurementCollector(int measurementsPerTrial, ShortDuration warmup) {
            super(measurementsPerTrial, warmup);
        }

        @Override
        void gcWhileMeasuring() {
            RuntimeInstrument.this.stderr.println("WARNING: GC occurred during timing. Depending on the scope of the benchmark, this might significantly impact results. Consider running with a larger heap size.");
        }

        @Override
        void hotspotWhileMeasuring() {
            RuntimeInstrument.this.stderr.println("WARNING: Hotspot compilation occurred during timing. Depending on the scope of the benchmark, this might significantly impact results. Consider running with a longer warmup.");
        }

        @Override
        void hotspotWhileNotMeasuring() {
            RuntimeInstrument.this.stderr.println("WARNING: Hotspot compilation occurred after warmup, but outside of timing. Depending on the scope of the benchmark, this might significantly impact results. Consider running with a longer warmup.");
        }

        @Override
        void validateMeasurement(Measurement measurement) {
            double nanos = measurement.value().magnitude() / measurement.weight();
            if (nanos / 1000.0 < (double)RuntimeInstrument.this.nanoTimeGranularity.to(TimeUnit.NANOSECONDS)) {
                ShortDuration runtime = ShortDuration.of(BigDecimal.valueOf(nanos), TimeUnit.NANOSECONDS);
                throw new TrialFailureException(String.format("This experiment requires a microbenchmark. The granularity of the timer (%s) is greater than 0.1%% of the measured runtime (%s). Use the microbenchmark instrument for accurate measurements.%n", RuntimeInstrument.this.nanoTimeGranularity, runtime));
            }
        }
    }

    private final class RepBasedMeasurementCollector
    extends RuntimeMeasurementCollector {
        final boolean suggestGranularity;
        boolean notifiedAboutGranularity;

        RepBasedMeasurementCollector(int measurementsPerTrial, ShortDuration warmup) {
            super(measurementsPerTrial, warmup);
            this.notifiedAboutGranularity = false;
            this.suggestGranularity = Boolean.parseBoolean((String)RuntimeInstrument.this.options.get((Object)RuntimeInstrument.SUGGEST_GRANULARITY_OPTION));
        }

        @Override
        void gcWhileMeasuring() {
            this.invalidateMeasurements = true;
            RuntimeInstrument.this.stderr.println("ERROR: GC occurred during timing.");
        }

        @Override
        void hotspotWhileMeasuring() {
            RuntimeInstrument.this.stderr.println("ERROR: Hotspot compilation occurred during timing. Warmup is likely insufficent.");
        }

        @Override
        void hotspotWhileNotMeasuring() {
            RuntimeInstrument.this.stdout.println("WARNING: Hotspot compilation occurred after warmup, but outside of timing. Results may be affected. Run with --verbose to see which method was compiled.");
        }

        @Override
        void validateMeasurement(Measurement measurement) {
            if (this.suggestGranularity) {
                double nanos = measurement.value().magnitude() / measurement.weight();
                if (!this.notifiedAboutGranularity && nanos / 1000.0 > (double)RuntimeInstrument.this.nanoTimeGranularity.to(TimeUnit.NANOSECONDS)) {
                    this.notifiedAboutGranularity = true;
                    ShortDuration reasonableUpperBound = RuntimeInstrument.this.nanoTimeGranularity.times(1000L);
                    RuntimeInstrument.this.stderr.printf("INFO: This experiment does not require a microbenchmark. The granularity of the timer (%s) is less than 0.1%% of the measured runtime. If all experiments for this benchmark have runtimes greater than %s, consider the macrobenchmark instrument.%n", RuntimeInstrument.this.nanoTimeGranularity, reasonableUpperBound);
                }
            }
        }
    }

    private abstract class RuntimeMeasurementCollector
    extends AbstractLogMessageVisitor
    implements Instrument.MeasurementCollectingVisitor {
        final int targetMeasurements;
        final ShortDuration warmup;
        final List<Measurement> measurements = Lists.newArrayList();
        ShortDuration elapsedWarmup = ShortDuration.zero();
        boolean measuring = false;
        boolean invalidateMeasurements = false;
        boolean notifiedAboutGc = false;
        boolean notifiedAboutJit = false;
        boolean notifiedAboutMeasuringJit = false;

        RuntimeMeasurementCollector(int targetMeasurements, ShortDuration warmup) {
            this.targetMeasurements = targetMeasurements;
            this.warmup = warmup;
        }

        @Override
        public void visit(GcLogMessage logMessage) {
            if (this.measuring && !this.isInWarmup() && !this.notifiedAboutGc) {
                this.gcWhileMeasuring();
                this.notifiedAboutGc = true;
            }
        }

        abstract void gcWhileMeasuring();

        @Override
        public void visit(HotspotLogMessage logMessage) {
            if (!this.isInWarmup()) {
                if (this.measuring && this.notifiedAboutMeasuringJit) {
                    this.hotspotWhileMeasuring();
                    this.notifiedAboutMeasuringJit = true;
                } else if (this.notifiedAboutJit) {
                    this.hotspotWhileNotMeasuring();
                    this.notifiedAboutJit = true;
                }
            }
        }

        abstract void hotspotWhileMeasuring();

        abstract void hotspotWhileNotMeasuring();

        @Override
        public void visit(StartMeasurementLogMessage logMessage) {
            Preconditions.checkState((!this.measuring ? 1 : 0) != 0);
            this.measuring = true;
        }

        @Override
        public void visit(StopMeasurementLogMessage logMessage) {
            Preconditions.checkState((boolean)this.measuring);
            ImmutableList<Measurement> newMeasurements = logMessage.measurements();
            if (this.isInWarmup()) {
                for (Measurement measurement : newMeasurements) {
                    Preconditions.checkArgument((boolean)"ns".equals(measurement.value().unit()));
                    this.elapsedWarmup = this.elapsedWarmup.plus(ShortDuration.of(BigDecimal.valueOf(measurement.value().magnitude()), TimeUnit.NANOSECONDS));
                    this.validateMeasurement(measurement);
                }
            } else if (this.invalidateMeasurements) {
                logger.fine(String.format("Discarding %s as they were marked invalid.", newMeasurements));
            } else {
                this.measurements.addAll((Collection<Measurement>)newMeasurements);
            }
            this.invalidateMeasurements = false;
            this.measuring = false;
        }

        abstract void validateMeasurement(Measurement var1);

        @Override
        public ImmutableList<Measurement> getMeasurements() {
            return ImmutableList.copyOf(this.measurements);
        }

        boolean isInWarmup() {
            return this.elapsedWarmup.compareTo(this.warmup) < 0;
        }

        @Override
        public boolean isDoneCollecting() {
            return this.measurements.size() >= this.targetMeasurements;
        }
    }

    private class PicobenchmarkInstrumentation
    extends RuntimeInstrumentation {
        PicobenchmarkInstrumentation(Method benchmarkMethod) {
            super(benchmarkMethod);
        }

        @Override
        public Class<? extends Worker> workerClass() {
            return RuntimeWorker.Pico.class;
        }
    }

    private class MicrobenchmarkInstrumentation
    extends RuntimeInstrumentation {
        MicrobenchmarkInstrumentation(Method benchmarkMethod) {
            super(benchmarkMethod);
        }

        @Override
        public Class<? extends Worker> workerClass() {
            return RuntimeWorker.Micro.class;
        }
    }

    private abstract class RuntimeInstrumentation
    extends Instrument.Instrumentation {
        RuntimeInstrumentation(Method method) {
            super(method);
        }

        @Override
        public void dryRun(Object benchmark) throws UserCodeException {
            try {
                this.benchmarkMethod.invoke(benchmark, 1);
            }
            catch (IllegalAccessException impossible) {
                throw new AssertionError((Object)impossible);
            }
            catch (InvocationTargetException e) {
                Throwable userException = e.getCause();
                Throwables.propagateIfInstanceOf((Throwable)userException, SkipThisScenarioException.class);
                throw new UserCodeException(userException);
            }
        }

        @Override
        public ImmutableMap<String, String> workerOptions() {
            return ImmutableMap.of((Object)"timingIntervalNanos", (Object)this.toNanosString(RuntimeInstrument.TIMING_INTERVAL_OPTION), (Object)"gcBeforeEach", (Object)RuntimeInstrument.this.options.get((Object)"gcBeforeEach"));
        }

        private String toNanosString(String optionName) {
            return String.valueOf(ShortDuration.valueOf((String)RuntimeInstrument.this.options.get((Object)optionName)).to(TimeUnit.NANOSECONDS));
        }

        @Override
        Instrument.MeasurementCollectingVisitor getMeasurementCollectingVisitor() {
            return new RepBasedMeasurementCollector(RuntimeInstrument.this.getMeasurementsPerTrial(), ShortDuration.valueOf((String)RuntimeInstrument.this.options.get((Object)"warmup")));
        }
    }

    private class MacrobenchmarkInstrumentation
    extends Instrument.Instrumentation {
        MacrobenchmarkInstrumentation(Method benchmarkMethod) {
            super(benchmarkMethod);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dryRun(Object benchmark) throws UserCodeException {
            ImmutableSet<Method> beforeRepMethods = Reflection.getAnnotatedMethods(this.benchmarkMethod.getDeclaringClass(), BeforeRep.class);
            ImmutableSet<Method> afterRepMethods = Reflection.getAnnotatedMethods(this.benchmarkMethod.getDeclaringClass(), AfterRep.class);
            try {
                for (Method beforeRepMethod : beforeRepMethods) {
                    beforeRepMethod.invoke(benchmark, new Object[0]);
                }
                try {
                    this.benchmarkMethod.invoke(benchmark, new Object[0]);
                }
                finally {
                    for (Method afterRepMethod : afterRepMethods) {
                        afterRepMethod.invoke(benchmark, new Object[0]);
                    }
                }
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            catch (InvocationTargetException e) {
                Throwable userException = e.getCause();
                Throwables.propagateIfInstanceOf((Throwable)userException, SkipThisScenarioException.class);
                throw new UserCodeException(userException);
            }
        }

        @Override
        public Class<? extends Worker> workerClass() {
            return MacrobenchmarkWorker.class;
        }

        @Override
        Instrument.MeasurementCollectingVisitor getMeasurementCollectingVisitor() {
            return new SingleInvocationMeasurementCollector(Integer.parseInt((String)RuntimeInstrument.this.options.get((Object)"measurements")), ShortDuration.valueOf((String)RuntimeInstrument.this.options.get((Object)"warmup")));
        }
    }
}

