/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner;

import com.google.caliper.api.SkipThisScenarioException;
import com.google.caliper.bridge.AbstractLogMessageVisitor;
import com.google.caliper.bridge.StopMeasurementLogMessage;
import com.google.caliper.model.ArbitraryMeasurement;
import com.google.caliper.model.Measurement;
import com.google.caliper.runner.Instrument;
import com.google.caliper.runner.InvalidBenchmarkException;
import com.google.caliper.runner.UserCodeException;
import com.google.caliper.util.Util;
import com.google.caliper.worker.ArbitraryMeasurementWorker;
import com.google.caliper.worker.Worker;
import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;

public final class ArbitraryMeasurementInstrument
extends Instrument {
    @Override
    public boolean isBenchmarkMethod(Method method) {
        return method.isAnnotationPresent(ArbitraryMeasurement.class);
    }

    @Override
    public Instrument.Instrumentation createInstrumentation(Method benchmarkMethod) throws InvalidBenchmarkException {
        if (benchmarkMethod.getParameterTypes().length != 0) {
            throw new InvalidBenchmarkException("Arbitrary measurement methods should take no parameters: " + benchmarkMethod.getName(), new Object[0]);
        }
        if (benchmarkMethod.getReturnType() != Double.TYPE) {
            throw new InvalidBenchmarkException("Arbitrary measurement methods must have a return type of double: " + benchmarkMethod.getName(), new Object[0]);
        }
        if (Util.isStatic(benchmarkMethod)) {
            throw new InvalidBenchmarkException("Arbitrary measurement methods must not be static: " + benchmarkMethod.getName(), new Object[0]);
        }
        if (!Util.isPublic(benchmarkMethod)) {
            throw new InvalidBenchmarkException("Arbitrary measurement methods must be public: " + benchmarkMethod.getName(), new Object[0]);
        }
        return new ArbitraryMeasurementInstrumentation(benchmarkMethod);
    }

    @Override
    public ImmutableSet<String> instrumentOptions() {
        return ImmutableSet.of((Object)"gcBeforeEach");
    }

    private static final class SingleMeasurementCollectingVisitor
    extends AbstractLogMessageVisitor
    implements Instrument.MeasurementCollectingVisitor {
        Optional<Measurement> measurement = Optional.absent();

        private SingleMeasurementCollectingVisitor() {
        }

        @Override
        public boolean isDoneCollecting() {
            return this.measurement.isPresent();
        }

        @Override
        public ImmutableList<Measurement> getMeasurements() {
            return ImmutableList.copyOf((Collection)this.measurement.asSet());
        }

        @Override
        public void visit(StopMeasurementLogMessage logMessage) {
            this.measurement = Optional.of((Object)Iterables.getOnlyElement(logMessage.measurements()));
        }
    }

    private final class ArbitraryMeasurementInstrumentation
    extends Instrument.Instrumentation {
        protected ArbitraryMeasurementInstrumentation(Method benchmarkMethod) {
            super(ArbitraryMeasurementInstrument.this, benchmarkMethod);
        }

        @Override
        public void dryRun(Object benchmark) throws InvalidBenchmarkException {
            try {
                this.benchmarkMethod.invoke(benchmark, new Object[0]);
            }
            catch (IllegalAccessException impossible) {
                throw new AssertionError((Object)impossible);
            }
            catch (InvocationTargetException e) {
                Throwable userException = e.getCause();
                Throwables.propagateIfInstanceOf((Throwable)userException, SkipThisScenarioException.class);
                throw new UserCodeException(userException);
            }
        }

        @Override
        public Class<? extends Worker> workerClass() {
            return ArbitraryMeasurementWorker.class;
        }

        @Override
        public ImmutableMap<String, String> workerOptions() {
            return ImmutableMap.of((Object)"gcBeforeEach", (Object)ArbitraryMeasurementInstrument.this.options.get((Object)"gcBeforeEach"));
        }

        @Override
        Instrument.MeasurementCollectingVisitor getMeasurementCollectingVisitor() {
            return new SingleMeasurementCollectingVisitor();
        }
    }
}

