/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.model;

import com.google.caliper.model.ExcludeFromJson;
import com.google.caliper.model.PersistentHashing;
import com.google.caliper.model.StringMapFunnel;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import com.google.common.hash.Funnel;
import java.util.Map;
import java.util.SortedMap;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.NamedQuery;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.QueryHint;
import org.hibernate.annotations.Immutable;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Sort;
import org.hibernate.annotations.SortType;

@Entity
@Access(value=AccessType.FIELD)
@Immutable
@Cacheable
@NamedQuery(name="listInstrumentSpecsForHash", query="SELECT i FROM InstrumentSpec i WHERE hash = :hash", hints={@QueryHint(name="org.hibernate.cacheable", value="true"), @QueryHint(name="org.hibernate.readOnly", value="true")})
public final class InstrumentSpec {
    static final InstrumentSpec DEFAULT = new InstrumentSpec();
    @Id
    @GeneratedValue
    @ExcludeFromJson
    private int id;
    @Basic(optional=false)
    private String className;
    @ElementCollection
    @Sort(type=SortType.NATURAL)
    private SortedMap<String, String> options;
    @ExcludeFromJson
    @Index(name="hash_index")
    private int hash;

    private InstrumentSpec() {
        this.className = "";
        this.options = Maps.newTreeMap();
    }

    private InstrumentSpec(Builder builder) {
        this.className = builder.className;
        this.options = Maps.newTreeMap((SortedMap)builder.options);
    }

    public String className() {
        return this.className;
    }

    public ImmutableSortedMap<String, String> options() {
        return ImmutableSortedMap.copyOf(this.options);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof InstrumentSpec) {
            InstrumentSpec that = (InstrumentSpec)obj;
            return this.className.equals(that.className) && this.options.equals(that.options);
        }
        return false;
    }

    @PrePersist
    @PreUpdate
    private void initHash() {
        if (this.hash == 0) {
            this.hash = PersistentHashing.getPersistentHashFunction().newHasher().putUnencodedChars((CharSequence)this.className).putObject(this.options, (Funnel)StringMapFunnel.INSTANCE).hash().asInt();
        }
    }

    public int hashCode() {
        this.initHash();
        return this.hash;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("className", (Object)this.className).add("options", this.options).toString();
    }

    public static final class Builder {
        private String className;
        private final SortedMap<String, String> options = Maps.newTreeMap();

        public Builder className(String className) {
            this.className = (String)Preconditions.checkNotNull((Object)className);
            return this;
        }

        public Builder instrumentClass(Class<?> insturmentClass) {
            return this.className(insturmentClass.getName());
        }

        public Builder addOption(String option, String value) {
            this.options.put(option, value);
            return this;
        }

        public Builder addAllOptions(Map<String, String> options) {
            this.options.putAll(options);
            return this;
        }

        public InstrumentSpec build() {
            Preconditions.checkState((this.className != null ? 1 : 0) != 0);
            return new InstrumentSpec(this);
        }
    }
}

