/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.internal;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.fest.util.Closeables;
import org.fest.util.Objects;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Diff {
    private static final String EOF = "EOF";

    Diff() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> diff(InputStream actual, InputStream expected) throws IOException {
        List<String> list;
        BufferedReader reader1 = null;
        BufferedReader reader2 = null;
        try {
            reader1 = this.readerFor(actual);
            reader2 = this.readerFor(expected);
            list = Collections.unmodifiableList(this.diff(reader1, reader2));
        }
        catch (Throwable throwable) {
            Closeables.close((Closeable[])new Closeable[]{reader1});
            Closeables.close((Closeable[])new Closeable[]{reader2});
            throw throwable;
        }
        Closeables.close((Closeable[])new Closeable[]{reader1});
        Closeables.close((Closeable[])new Closeable[]{reader2});
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> diff(File actual, File expected) throws IOException {
        List<String> list;
        BufferedReader reader1 = null;
        BufferedReader reader2 = null;
        try {
            reader1 = this.readerFor(actual);
            reader2 = this.readerFor(expected);
            list = Collections.unmodifiableList(this.diff(reader1, reader2));
        }
        catch (Throwable throwable) {
            Closeables.close((Closeable[])new Closeable[]{reader1});
            Closeables.close((Closeable[])new Closeable[]{reader2});
            throw throwable;
        }
        Closeables.close((Closeable[])new Closeable[]{reader1});
        Closeables.close((Closeable[])new Closeable[]{reader2});
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> diff(File actual, String expected, Charset charset) throws IOException {
        List<String> list;
        BufferedReader reader1 = null;
        try {
            reader1 = this.readerFor(actual, charset);
            BufferedReader reader2 = this.readerFor(expected);
            list = Collections.unmodifiableList(this.diff(reader1, reader2));
        }
        catch (Throwable throwable) {
            Closeables.close((Closeable[])new Closeable[]{reader1});
            throw throwable;
        }
        Closeables.close((Closeable[])new Closeable[]{reader1});
        return list;
    }

    private BufferedReader readerFor(InputStream stream) {
        return new BufferedReader(new InputStreamReader(stream));
    }

    private BufferedReader readerFor(InputStream stream, Charset charset) {
        return new BufferedReader(new InputStreamReader(stream, charset));
    }

    private BufferedReader readerFor(File file) throws IOException {
        return this.readerFor(new FileInputStream(file));
    }

    private BufferedReader readerFor(File file, Charset charset) throws IOException {
        return this.readerFor(new FileInputStream(file), charset);
    }

    private BufferedReader readerFor(String string) {
        return new BufferedReader(new StringReader(string));
    }

    private List<String> diff(BufferedReader reader1, BufferedReader reader2) throws IOException {
        ArrayList<String> diffs = new ArrayList<String>();
        int lineNumber = 0;
        while (true) {
            String line1 = reader1.readLine();
            String line2 = reader2.readLine();
            if (line1 == null || line2 == null) {
                if (line2 != null) {
                    diffs.add(this.output(lineNumber, EOF, line2));
                }
                if (line1 != null) {
                    diffs.add(this.output(lineNumber, line1, EOF));
                }
                return diffs;
            }
            if (!Objects.areEqual((Object)line1, (Object)line2)) {
                diffs.add(this.output(lineNumber, line1, line2));
            }
            ++lineNumber;
        }
    }

    private String output(int lineNumber, String actual, String expected) {
        return String.format("line:<%d>, expected:<%s> but was:<%s>", lineNumber, expected, actual);
    }
}

