/*
 * Decompiled with CFR 0.152.
 */
package de.xam.resourceloader.p13n;

import de.xam.p13n.server.LocaleUtils;
import de.xam.p13n.shared.MiniLocale;
import de.xam.p13n.shared.Personalisation;
import de.xam.p13n.shared.SharedLocaleUtils;
import de.xam.p13n.shared.SharedP13nUtils;
import de.xam.resourceloader.p13n.time.TimeZoneUtils;
import java.text.DateFormat;
import java.util.List;
import java.util.Locale;
import org.joda.time.DateTime;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class P13nUtils
extends SharedP13nUtils {
    private static final Logger log = LoggerFactory.getLogger(P13nUtils.class);

    public static Personalisation computePersonalisation(String acceptLanguageHeader, String ipAddress, String preferredLocale, Personalisation storedP13n, Personalisation defaulP13n) {
        MiniLocale locale;
        if (preferredLocale != null) {
            log.debug("Using p13n from URL param " + preferredLocale);
            MiniLocale locale2 = SharedLocaleUtils.fromString((String)preferredLocale);
            return new Personalisation(locale2, TimeZoneUtils.guessTimezoneOffset(locale2));
        }
        if (storedP13n != null) {
            log.debug("Using stored p13n " + storedP13n);
            return storedP13n;
        }
        log.debug("Guessing p13n from HTTP accept headers...");
        List langDefs = LocaleUtils.parseAcceptLanguageHeader((String)acceptLanguageHeader);
        if (langDefs.isEmpty()) {
            return defaulP13n;
        }
        LocaleUtils.LangDef preferred = (LocaleUtils.LangDef)langDefs.get(0);
        String localeCode = preferred.getLang().replace("-", "_");
        try {
            locale = MiniLocale.fromLocaleCode((String)localeCode);
        }
        catch (IllegalArgumentException e) {
            locale = MiniLocale.ENGLISH;
        }
        return new Personalisation(locale, TimeZoneUtils.guessTimezoneOffset(locale));
    }

    public static String personalise(DateTime date, Personalisation p13n, boolean renderDate, boolean renderTime) {
        DateFormat df;
        Locale javaLocale = P13nUtils.toJavaLocale(p13n.getLocale());
        if (renderDate && renderTime) {
            df = DateFormat.getDateTimeInstance(0, 0, javaLocale);
        } else if (renderDate) {
            df = DateFormat.getDateInstance(0, javaLocale);
        } else if (renderTime) {
            df = DateFormat.getTimeInstance(0, javaLocale);
        } else {
            throw new IllegalArgumentException("At least one of renderDate or renderTime should be true");
        }
        String personalisedDateTime = df.format(date.toDate());
        if (SharedP13nUtils.isDebugger((Personalisation)p13n)) {
            personalisedDateTime = personalisedDateTime + " (UTC: " + date.getMillis() + ")";
        }
        return personalisedDateTime;
    }

    public static Locale toJavaLocale(MiniLocale miniLocale) {
        assert (miniLocale != null);
        String country = miniLocale.getCountry();
        String language = miniLocale.getLanguage();
        String variant = miniLocale.getVariant();
        if (language == null) {
            throw new IllegalArgumentException("language was null");
        }
        if (country == null) {
            return new Locale(language);
        }
        if (variant == null) {
            return new Locale(language, country);
        }
        return new Locale(language, country, variant);
    }
}

